#!/usr/bin/env bash

echo "Starting Simple Nuget Server..."

# mount the nfs volume for package repository and database
if [ -n "$NUGET_EFS_MOUNT_URL" ]; then
	echo "Mounting EFS Volume..."

	mkdir mount;
	chown www:www mount;

	echo -e "$NUGET_EFS_MOUNT_URL:/ /opt/simple-nuget-server/mount nfs4 nfsvers=4.1,rsize=1048576,wsize=1048576,hard,timeo=600,retrans=2,noauto 0 0" >> /etc/fstab
	mount /opt/simple-nuget-server/mount

	if [ ! -d mount/packagefiles ]; then 
		mkdir mount/packagefiles; 
		chown www:www mount/packagefiles; 
	fi
fi

# update php max upload size
sed -i /etc/php7/php.ini -e "s/upload_max_filesize = 2M/upload_max_filesize = $NUGET_UPLOAD_MAX_FILESIZE/"

echo "Starting PHP and Nginx..."
# start the php fastcgi daemon
php-fpm7

# go!
nginx
