#!/usr/bin/env ruby
# frozen_string_literal: true

require 'aws-sdk'
require 'json'

deploy_service = '%deploy.service%'
task_revisions = JSON.parse('%task.revisions%')

uncovered_envs = deploy_environments - task_revisions.keys
if uncovered_envs.count.positive?
  fatal "Found #{uncovered_envs.count} environment(s) without task_revisions. Uncovered: #{uncovered_envs.inspect}"
  return
end

deploy_environments.each do |environment|
  info "Updating #{deploy_service} in #{environment} to use "

  definition = "#{deploy_service}:#{task_revisions[environment]}"
  service = ecs_client(region: environment).update_service cluster: '%deploy.cluster%', service: '%deploy.service%', task_definition: definition, desired_count: '%deploy.count%'
  info "Update complete in #{environment}"
  debug JSON.pretty_unparse(service.to_h)
end
