import jetbrains.buildServer.configs.kotlin.v2018_2.buildSteps.exec
import jetbrains.buildServer.configs.kotlin.v2018_2.buildSteps.script
import jetbrains.buildServer.configs.kotlin.v2018_2.version
// to download instrumentorum as a maven dependency, you will need to be on TwitchVPN
import twitch.instrumentorum.instrum
import twitch.instrumentorum.project.builds.initializeBuildChain

// specify the TeamCity DSL version
version = "2018.2"

// requires maven
// to generate/compile:
// cd .teamcity
// mvn teamcity-configs:generate

instrum {
    description = "TeamCity Kotlin Demo"

    // TODO: Update the source root to match your repository
    sourceRoot("git@git-aws.internal.justin.tv:MyTeam/myrepo.git")

    textParam("my.parameter", "value", "Label My Parameter", "Describe what my parameter is for")

    // initializeBuildChain creates a BuildType that performs common, sane steps to help with identifying builds
    initializeBuildChain ()

    // when using instrumentorum, builds will auto-chain to the previous build in the config
    // so this build will automatically get a dependency on the initialization build defined above
    build("Build Things") {
        steps {
            script {
                name = "Run a Ruby Script"
                scriptContent = """
                    #!/usr/bin/env ruby
                    puts "I'm running a ruby script in TeamCity!"
                """.trimIndent()
            }

            exec {
                name = "Exec a Shell Command"
                path = "pwd"
                arguments = "-P"
            }

            script {
                name = "This Will Fail"
                scriptContent = """
                    #!/usr/bin/env ruby
                    abort 'Look ma! I did it!'
                """.trimIndent()
            }
        }
    }
}
