# TeamCity Kotlin DSL Usage
## Getting Started
- [TeamCity DSL 2018.x Getting Started](https://confluence.jetbrains.com/display/TCD18/Kotlin+DSL#KotlinDSL-GettingStartedwithKotlinDSL)
- [TeamCity DSL 2018.2 Documentation](https://teamcity.jetbrains.com/app/dsl-documentation/jetbrains.build-server.configs.kotlin.v2018_2/index.html)
## Recommendations/Requirements
1. There's no way around it - IntelliJ IDEA is the best IDE for working with Kotlin. It is available via the Amazon IT Marketplace.
2. Java 1.8
3. Maven ~> 3.6.0
## Generating Configs
```
➜ cd .teamcity
➜ mvn teamcity-configs:generate
[INFO] Scanning for projects...
[INFO]
[INFO] ------------< TeamcityConfiguration:TeamcityConfiguration >-------------
[INFO] Building Teamcity Configuration 1.0-SNAPSHOT
[INFO] --------------------------------[ jar ]---------------------------------
[WARNING] The POM for cloud.twitch.csi:instrumentorum:jar:0.2.0-20190220.195311-27 is invalid, transitive dependencies (if any) will not be available, enable debug logging for more details
[INFO]
[INFO] --- teamcity-configs-maven-plugin:2018.2:generate (default-cli) @ TeamcityConfiguration ---
[INFO] Generate TeamCity configs in ~/Development/teamcity-kotlin-base/.teamcity/target/generated-configs, format kotlin, dslDir: ~/Development/teamcity-kotlin-base/.teamcity
[INFO] ------------------------------------------------------------------------
[INFO] BUILD SUCCESS
[INFO] ------------------------------------------------------------------------
[INFO] Total time:  6.125 s
[INFO] Finished at: 2019-03-08T15:30:05-08:00
[INFO] ------------------------------------------------------------------------
```
Output goes to .teamcity/target/generated-configs
