import jetbrains.buildServer.configs.kotlin.v2018_1.*
import jetbrains.buildServer.configs.kotlin.v2018_1.buildSteps.exec
import jetbrains.buildServer.configs.kotlin.v2018_1.buildSteps.script
import jetbrains.buildServer.configs.kotlin.v2018_1.vcs.GitVcsRoot
import java.io.File

// Useful doc link that seems stupidly hard to find
// https://teamcity.internal.justin.tv/app/dsl-documentation/index.html
// https://teamcity.internal.justin.tv/app/dsl-documentation/jetbrains.build-server.configs.kotlin.v2018_1/index.html

version = "2018.1"

object ProjectSource : GitVcsRoot({
    id("ProjectSourceRoot")
    name = "Project Source"

    url = "git@git-aws.internal.justin.tv:<source project>"
    authMethod = uploadedKey {
        uploadedKey = "id_rsa_teamcity"
    }

    branch = "%git.default_branch%"
    branchSpec = "%git.branch_spec%"
})

object SettingsRoot : GitVcsRoot({
    id("SettingsRoot")
    name = "Teamcity Versioned Settings"

    url = "git@git-aws.internal.justin.tv:<settings root project>"
    authMethod = uploadedKey {
        uploadedKey = "id_rsa_teamcity"
    }
})

project {
    description = "My TeamCity Project"

    vcsRoot(SettingsRoot)
    vcsRoot(ProjectSource)

    params {
        text("git.default_branch", "refs/heads/master", "Default Branch", "What branch to treat as the default for a given build configuration.", ParameterDisplay.HIDDEN)
        text("git.branch_spec", "+:refs/heads/*", "Branch Spec", "What branches should we additionally watch or ignore?", ParameterDisplay.HIDDEN)
    }
}
