# frozen_string_literal: true

require 'indicina/patches'

require 'indicina/db'
require 'indicina/indexer'
require 'indicina/logging'
require 'indicina/s3'

module Indicina
  class Mash < Hashie::Mash
    include Hashie::Extensions::Mash::SymbolizeKeys
  end

  class << self
    def enable_parallel_execution
      @parallelize = true
      Indicina::Logging.log_level = :warn
    end

    def parallelize?
      @parallelize
    end
  end
end
