# frozen_string_literal: true

require 'indicina/logging'
require 'indicina/generator'

require 'thor'
require 'time'

module Indicina

  class CLI < Thor
    extend Logging

    def self.exit_on_failure?
      true
    end

    class_option :debug, desc: 'Enables debug logging.', default: false, type: :boolean
    class_option :parallelize, desc: 'Enables parallel execution where appropriate, and mutes most logging.', default: false, type: :boolean

    desc 'index TEST-SUITE', 'Attempts to index a specific test suite.'
    def index(test_suite)
      Indicina.enable_parallel_execution if options[:parallelize]
      Logging.log_level = :debug if options[:debug]
      Indexer.new(test_suite).index
    end

    desc 'report TEST-SUITE', 'Generates a report for a specific test suite.'
    method_option :report, desc: 'The name of the report to generate.', required: true, type: :string
    def report(test_suite)
      Indicina.enable_parallel_execution if options[:parallelize]
      Logging.log_level = :debug if options[:debug]
      Generator.new(test_suite, options[:report]).generate
    end
  end

end
