# frozen_string_literal: true

require 'sequel'
require 'indicina/constants'

module Indicina
  Sequel.default_timezone = :utc

  DB = Sequel.connect(CONNECTION_STRING)
  DB.extension :connection_validator

  Sequel::Model.plugin :timestamps, update_on_create: true

  models_splat = File.join(File.dirname(__FILE__), 'models', '*.rb')
  Dir[models_splat].each { |model| require model }

  DB.freeze
  DB.disconnect
end
