# frozen_string_literal: true

require 'active_support/inflector'

class String
  def indent(depth = 1, size = 4)
    split("\n", -1).collect { |line| (' ' * size * depth) + line }.join("\n")
  end

  def sanitize
    gsub(/[^0-9A-Z]+/i, '-')
  end
end

class Numeric
  def pretty
    to_s.reverse.gsub(/(\d{3})(?=\d)/, '\\1,').reverse
  end
end
