# frozen_string_literal: true

require 'aws-sdk-s3'

Aws.config.update region: 'us-east-1'

if ENV['AWS_TOKEN']
  aws_token = JSON.parse(ENV['AWS_TOKEN'])

  Aws.config.update credentials: Aws::Credentials.new(
    aws_token['Credentials']['AccessKeyId'],
    aws_token['Credentials']['SecretAccessKey'],
    aws_token['Credentials']['SessionToken']
  )
else
  Aws.config.update profile: 'cpe-benchmarking'
end

module Indicina
  class << self
    def s3_client
      @s3_client ||= Aws::S3::Resource.new.bucket('tegimen-useast1-4bf74081c7ed2799b42c6931761ec69e9c6e229cfe10d8a')
    end
  end
end
