# frozen_string_literal: true

require 'tegimen/patches'

require 'tegimen/cli'
require 'tegimen/test_suite'

require 'hashie'

module Tegimen
  class Mash < Hashie::Mash
    include Hashie::Extensions::Mash::SymbolizeKeys
  end

  class << self
    def enable_parallel_execution
      @parallelize = true
      Tegimen::Logging.logging_level = :WARN
    end

    def parallelize?
      @parallelize
    end
  end
end
