# frozen_string_literal: true

require 'aws-sdk-s3'

Aws.config.update region: 'us-east-1'
if ENV['AWS_TOKEN']
  AWS_TOKEN = JSON.parse(ENV['AWS_TOKEN'])
  Aws.config.update credentials: Aws::Credentials.new(
    AWS_TOKEN['Credentials']['AccessKeyId'],
    AWS_TOKEN['Credentials']['SecretAccessKey'],
    AWS_TOKEN['Credentials']['SessionToken']
  )
else
  Aws.config.update profile: 'cpe-benchmarking'
end

module Tegimen
  class << self
    def s3_client
      @s3_client ||= Aws::S3::Resource.new.bucket('tegimen-useast1-4bf74081c7ed2799b42c6931761ec69e9c6e229cfe10d8a')
    end
  end
end
