# frozen_string_literal: true

require 'time'

Sequel.migration do
  change do
    create_table(:test_suites) do
      primary_key :id

      column :name, String, null: false, unique: true

      column :created_at, Time, null: false
      column :updated_at, Time, null: false

      column :indexing_day, Time, default: Time.parse('2018-1-1 UTC')
    end
  end
end
