# frozen_string_literal: true

Sequel.migration do
  change do
    create_table(:tests) do
      column :id, String, null: false, unique: true, primary_key: true

      foreign_key :suite_id, :test_suites, null: false

      column :browser, String, size: 256, null: false
      column :experience, String, size: 256, null: false
      column :location, String, size: 256, null: false
      column :mobile_browser, String, size: 256
      column :platform, String, size: 256
      column :url, String, size: 2048, null: false
      column :sample_length, Integer, size: 256
      column :params, String, text: true, null: false

      column :bandwidth_down, Integer
      column :bandwidth_up, Integer
      column :latency, Integer
      column :tested_at, Time

      column :valid, TrueClass, default: true, null: false

      column :created_at, Time, null: false
      column :updated_at, Time, null: false
    end
  end
end
