# frozen_string_literal: true

Sequel.migration do
  change do
    create_table(:test_runs) do
      primary_key :id
      column :run, Integer, null: false

      unique [:test_id, :run]
      foreign_key :test_id, :tests, type: String

      column :tested_at, Time, null: false
      column :is_median, TrueClass, null: false

      # Timings
      column :first_byte, Integer, null: false # 100
      column :dom_loading, Integer, null: false # 165
      column :title_time, Integer, null: false # 409
      column :first_paint, Integer, null: false # 745
      column :render, Integer, null: false # 810
      column :dom_interactive, Integer, null: false # 1773
      column :load_time, Integer, null: false # 8629
      column :fully_loaded, Integer, null: false # 117470
      column :last_visual_change, Integer, null: false # 119914

      # Stats
      column :dom_elements, Integer, null: false
      column :bytes_out, Integer, null: false
      column :bytes_in, Integer, null: false
      column :connections, Integer, null: false
      column :requests, Integer, null: false
      column :responses_200, Integer, null: false
      column :responses_404, Integer, null: false
      column :responses_other, Integer, null: false
      column :domain_names, Integer, null: false

      column :created_at, Time, null: false
      column :updated_at, Time, null: false
    end
  end
end
