import { DataPoint } from "../DataPoint";

export class BceByClientKeyDestinationCountry extends DataPoint {

  static source: string = 'benchmark_custom_event'
  measurement: string = 'bce_by_client_key_destination_country'

  // TODO: Figure this crap out, still better in 2 places than 20
  static groups: string[] = [
    'country',
    'client_app',
    'destination',
    'key',
  ]
  groups: string[] = [
    'country',
    'client_app',
    'destination',
    'key',
  ]

  // TODO: Figure this crap out, still better in 2 places than 20
  static percentiles: number[] = [ 99, 95, 90, 75, 50 ]
  percentiles: number[]        = [ 99, 95, 90, 75, 50 ]

  public static query(day: string): string {
    return `
      WITH selection as (
        SELECT
          date_trunc('day', time) as day,
          duration,
          ${this.groups.join(', ')}
        FROM "tahoe"."${this.source}"
        WHERE date = '${day}'
        AND duration < 300000
        AND duration >= 0
        AND duration is not null
        AND (
          (client_app = 'twilight' AND key <> 'first-cue' AND page_component_name is not null AND lost_visibility = false)
          OR (client_app = 'twilight' AND key = 'first-cue' AND lost_visibility = false)
          OR (client_app <> 'twilight' OR client_app is null)
        ) 
        AND country IS NOT null
      ),
      agged as (
        SELECT
          day,
          ${this.groups.join(', ')},
          ${this.percentiles.map(p => {
            return `percentile_cont(0.${p}) within group (order by duration) over (partition by day, ${this.groups.join(', ')}) as duration_tp${p}`}).join(",\n")
          }
        FROM selection
      )

      select
        day,
        count(0) as count,
        ${this.groups.join(', ')},
        ${this.percentiles.map(p => { return `duration_tp${p}`}).join(', ')}
      from agged
      group by
        day,
        ${this.groups.join(', ')},
        ${this.percentiles.map(p => { return `duration_tp${p}`}).join(', ')}
      order by
        day,
        ${this.groups.join(', ')}
    `
  }

}