import { DataPoint } from "../DataPoint";

export class BciByClientComponentDestinationCountry extends DataPoint {

  static source: string = 'benchmark_component_interactive'
  measurement: string = 'bci_by_client_component_destination_country'

  // TODO: Figure this crap out, still better in 2 places than 20
  static groups: string[] = [
    'country',
    'client_app',
    'component',
    'destination'
  ]
  groups: string[] = [
    'country',
    'client_app',
    'component',
    'destination'
  ]

  // TODO: Figure this crap out, still better in 2 places than 20
  static percentiles: number[] = [ 99, 95, 90, 75, 50 ]
  percentiles: number[]        = [ 99, 95, 90, 75, 50 ]

  public static query(day: string): string {
    return `
      WITH selection as (
        SELECT
          date_trunc('day', time) as day,
          CASE WHEN duration IS NULL THEN time_from_initializing ELSE duration END AS duration,
          ${this.groups.join(', ')}
        FROM "tahoe"."${this.source}"
        WHERE date = '${day}'
        AND is_pre_pageload = false
        AND country IS NOT null
        AND client_app = 'twilight'
      ),
      agged as (
        SELECT
          day,
          ${this.groups.join(', ')},
          ${this.percentiles.map(p => {
            return `percentile_cont(0.${p}) within group (order by duration) over (partition by day, ${this.groups.join(', ')}) as duration_tp${p}`}).join(",\n")
          }
        FROM selection
        WHERE duration < 300000
        AND duration >= 0
        AND duration is not null
      )

      select
        day,
        count(0) as count,
        ${this.groups.join(', ')},
        ${this.percentiles.map(p => { return `duration_tp${p}`}).join(', ')}
      from agged
      group by
        day,
        ${this.groups.join(', ')},
        ${this.percentiles.map(p => { return `duration_tp${p}`}).join(', ')}
      order by
        day,
        ${this.groups.join(', ')}
    `
  }

}