#!/usr/bin/env ruby

def teamcity_parameter(key, value)
  puts "##teamcity[setParameter name='#{key}' value='#{value}']"
end

# May cause issues, for ex: a branch called testing/new-feature, and another called testing-new-feature will collide
def ecr_friendly_name(name)
  name.gsub(/_/, '-').downcase
end

teamcity_parameter('env.IMAGE_NAME', ecr_friendly_name(ENV['IMAGE_NAME']))
teamcity_parameter('env.IMAGE_VERSION', ecr_friendly_name(ENV['IMAGE_VERSION']))
