#!/usr/bin/env ruby

def teamcity_parameter(key, value)
  puts "##teamcity[setParameter name='#{key}' value='#{value}']"
end

# May cause issues, for ex: a branch called testing/new_feature, and another called testing-new-feature will collide
def nomad_friendly_name(branch_name)
  branch_name.gsub(/_/, '-').gsub(/\//, '-')
end

teamcity_parameter('env.NOMAD_BRANCH', nomad_friendly_name(ENV['BRANCH']))
