# frozen_string_literal: true

require_relative 'lib/route'

route '/', status: 200, backend: :twilight
route '/site_options.js', status: 200, backend: :legacy
route '/p/about', status: 200, backend: :cloudfront
route '/p/assets/uploads/wallstreet_deepfield_graph.jpg', status: 200, backend: :cloudfront
route '/p/legal/terms-of-service', status: 200, backend: :cloudfront
route '/p/terms-of-service', status: 302, location: '/p/terms-of-service/', backend: :cloudfront
route '/pr/welcome', status: 302, location: 'https://twitch.amazon.com/prime/welcome?ref_=sm_w_ty_page_redirect', backend: :legacy
route '/sw.js', status: 200, backend: :legacy, skip_backend_check: true
route '/broadcast', status: 200, backend: :legacy
route '/broadcast/stats', status: 200, backend: :legacy
route '/diresqrl/manager', status: 301, location: 'https://www.twitch.tv/diresqrl/manager/past_broadcasts', backend: :legacy
route '/blusewilly_retry/profile', status: 301, location: 'https://www.twitch.tv/blusewilly_retry/videos/all', backend: :legacy
route '/fantabobshow/profile', status: 301, location: 'https://www.twitch.tv/fantabobshow/videos/all', backend: :legacy
route '/forcat3636/profile', status: 301, location: 'https://www.twitch.tv/forcat3636/videos/all', backend: :legacy
route '/lirik/profile', status: 301, location: 'https://www.twitch.tv/lirik/videos/all', backend: :legacy
route '/diresqrl/report_form', status: 200, backend: :legacy
route '/diresqrl/dashboard', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fdiresqrl%2Fdashboard', backend: :legacy
route '/diresqrl/dashboard/action_log', status: 301, location: 'https://www.twitch.tv/diresqrl/dashboard/activity', backend: :legacy
route '/diresqrl/dashboard/activity', status: 200, backend: :legacy
route '/diresqrl/dashboard/delay', status: 404, backend: :legacy
route '/diresqrl/dashboard/revenue', status: 200, backend: :legacy
route '/diresqrl/dashboard/stats', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fdiresqrl%2Fdashboard%2Fstats', backend: :legacy
route '/broadcast/dashboard/streamkey', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fbroadcast%2Fdashboard%2Fstreamkey', backend: :legacy
route '/broadcast/dashboard', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fbroadcast%2Fdashboard', backend: :legacy
route '/broadcast/dashboards', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fbroadcast%2Fdashboards', backend: :legacy
route '/broadcast/dashboards/diresqrl', status: 301, location: 'https://www.twitch.tv/diresqrl/dashboard', backend: :legacy
route '/dashboard', status: 301, location: 'https://www.twitch.tv/broadcast/dashboard', backend: :legacy
route '/profile', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fprofile', backend: :legacy
route '/team/riotgames', status: 200, backend: :legacy
route '/team/riotgames/live_member_list', status: 200, backend: :legacy
route '/team/staff', status: 200, backend: :legacy
route '/team/staff/live_member_list', status: 200, backend: :legacy
route '/team/invitation', status: 404, backend: :legacy
route '/team/permission', status: 404, backend: :legacy
route '/chromecast/base64.js', status: 200, backend: :legacy, skip_backend_check: true
route '/chromecast/jquery.min.js', status: 200, backend: :legacy, skip_backend_check: true
route '/chromecast/media_receiver.html', status: 200, backend: :legacy, skip_backend_check: true
route '/chromecast/receiver.js', status: 200, backend: :legacy, skip_backend_check: true
route '/chromecast/spade.js', status: 200, backend: :legacy, skip_backend_check: true
route '/diresqrl/dashboard/subscription/merch-by-amazon', status: 200, backend: :legacy
route '/la2dreams/embed', status: 302, location: 'https://player.twitch.tv?channel=la2dreams', backend: :legacy
route '/lolesportsla/embed', status: 302, location: 'https://player.twitch.tv?channel=lolesportsla', backend: :legacy
route '/lvpes/embed', status: 302, location: 'https://player.twitch.tv?channel=lvpes', backend: :legacy
route '/riotgamesru/embed', status: 302, location: 'https://player.twitch.tv?channel=riotgamesru', backend: :legacy
route '/s4_league/embed', status: 302, location: 'https://player.twitch.tv?channel=s4_league', backend: :legacy
route '/summonersinnlive/embed', status: 302, location: 'https://player.twitch.tv?channel=summonersinnlive', backend: :legacy
route '/froggen/popout', status: 302, location: 'https://player.twitch.tv?channel=froggen', backend: :legacy
route '/imaqtpie/popout', status: 302, location: 'https://player.twitch.tv?channel=imaqtpie', backend: :legacy
route '/riotgames/popout', status: 302, location: 'https://player.twitch.tv?channel=riotgames', backend: :legacy
route '/scarra/popout', status: 302, location: 'https://player.twitch.tv?channel=scarra', backend: :legacy
route '/shiphtur/popout', status: 302, location: 'https://player.twitch.tv?channel=shiphtur', backend: :legacy
route '/vgbootcamp/popout', status: 302, location: 'https://player.twitch.tv?channel=vgbootcamp', backend: :legacy
route '/playbreakaway/streamplus', status: 200, backend: :legacy
route '/swflibs/TwitchPlayer.r1805fdf8cec14e5e658b83faaf6f985233b9432e.swf', status: 302, location: 'https://www-cdn.jtvnw.net/swflibs/TwitchPlayer.r94f0802bc518d3647d95c06804f6fcd16e81e44d.swf', backend: :legacy, skip_backend_check: true
route '/swflibs/TwitchPlayer.r94bb0312865162bc8384ec5050df550dacd90e6f.swf', status: 302, location: 'https://www-cdn.jtvnw.net/swflibs/TwitchPlayer.r94f0802bc518d3647d95c06804f6fcd16e81e44d.swf', backend: :legacy, skip_backend_check: true
route '/swflibs/TwitchPlayer.r94f0802bc518d3647d95c06804f6fcd16e81e44d.swf', status: 200, backend: :legacy, skip_backend_check: true
route '/swflibs/TwitchPlayer.rec8c4ca12340437be4d114de260aacbc24bdb830.swf', status: 302, location: 'https://www-cdn.jtvnw.net/swflibs/TwitchPlayer.r94f0802bc518d3647d95c06804f6fcd16e81e44d.swf', backend: :legacy, skip_backend_check: true
route '/swflibs/TwitchPlayer.rfc07d37fc4eed1d17243b452dd3441665496e1e0.swf', status: 302, location: 'https://www-cdn.jtvnw.net/swflibs/TwitchPlayer.r94f0802bc518d3647d95c06804f6fcd16e81e44d.swf', backend: :legacy, skip_backend_check: true
route '/swflibs/TwitchPlayer.swf', status: 302, location: 'https://www-cdn.jtvnw.net/swflibs/TwitchPlayer.r94f0802bc518d3647d95c06804f6fcd16e81e44d.swf', backend: :legacy, skip_backend_check: true
route '/widgets/archive_embed_player.swf', status: 302, location: 'http://www.twitch.tv/swflibs/TwitchPlayer.swf?old=1', backend: :legacy, skip_backend_check: true
route '/widgets/archive_facebook_embed_player.swf', status: 302, location: 'http://www.twitch.tv/swflibs/TwitchPlayer.swf?old=1', backend: :legacy, skip_backend_check: true
route '/widgets/clip_embed_player.swf', status: 302, location: 'http://www.twitch.tv/swflibs/TwitchPlayer.swf?old=1', backend: :legacy, skip_backend_check: true
route '/widgets/live_embed_player.r245719c13c44924ecaa2ddd8a106c88b7583fa76.swf', status: 406, backend: :legacy, skip_backend_check: true
route '/widgets/live_embed_player.swf', status: 302, location: 'http://www.twitch.tv/swflibs/TwitchPlayer.swf?old=1', backend: :legacy, skip_backend_check: true
route '/widgets/live_facebook_embed_player.swf', status: 302, location: 'http://www.twitch.tv/swflibs/TwitchPlayer.swf?old=1', backend: :legacy, skip_backend_check: true
route '/buks/v/3753822', status: 301, location: 'https://www.twitch.tv/videos/3753822', backend: :legacy
route '/egltv/v/3750607', status: 301, location: 'https://www.twitch.tv/videos/3750607', backend: :legacy
route '/hcjustin/v/64596746', status: 301, location: 'https://www.twitch.tv/videos/64596746', backend: :legacy
route '/logan4prezz/v/5964253', status: 301, location: 'https://www.twitch.tv/videos/5964253', backend: :legacy
route '/pielord1177/v/180517428', status: 301, location: 'https://www.twitch.tv/videos/180517428', backend: :legacy
route '/timmac/v/3778450', status: 301, location: 'https://www.twitch.tv/videos/3778450', backend: :legacy
route '/hrkchannel/videos/all', status: 200, backend: :twilight
route '/lirik/videos/all', status: 200, backend: :twilight
route '/reckful/videos/all', status: 200, backend: :twilight
route '/riotgames/videos/all', status: 200, backend: :twilight
route '/sp4zie/videos/all', status: 200, backend: :twilight
route '/collections/cSDu1TMk1hQOLA', status: 200, backend: :twilight
route '/collections/F7SKTkBOrBTZZQ', status: 200, backend: :twilight
route '/collections/FCJIcx5C5BQ0Ag', status: 200, backend: :twilight
route '/collections/jZafP4Nt3xT8Cw', status: 200, backend: :twilight
route '/collections/p8vZLZy06RRflw', status: 200, backend: :twilight
route '/collections/QboGeM5wrBRESA', status: 200, backend: :twilight
route '/diresqrl/dashboard/video-stats', status: 200, backend: :legacy
route '/upload', status: 301, location: 'https://www.twitch.tv/manager/upload', backend: :legacy
route '/diresqrl/manager/past_broadcasts', status: 200, backend: :legacy
route '/diresqrl/manager/uploads', status: 200, backend: :legacy
route '/manager/past_broadcasts', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fmanager%2Fpast_broadcasts', backend: :legacy
route '/manager/upload', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fmanager%2Fupload', backend: :legacy
route '/manager/uploads', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fmanager%2Fuploads', backend: :legacy
route '/videos/180336153', status: 200, backend: :twilight
route '/videos/180343443', status: 200, backend: :twilight
route '/videos/180430384', status: 200, backend: :twilight
route '/videos/180612409', status: 200, backend: :twilight
route '/videos/180616217', status: 200, backend: :twilight
route '/streams/26432425024/channel/54825274', status: 200, backend: :legacy
route '/streams/26433734560/channel/64215353', status: 200, backend: :legacy
route '/streams/26436054752/channel/38340508', status: 200, backend: :legacy
route '/streams/26436612000/channel/161149071', status: 200, backend: :legacy
route '/streams/26437459792/channel/37323664', status: 200, backend: :legacy
route '/streams/26438327248/channel/156567621', status: 200, backend: :legacy
route '/alanzoka/collections', status: 200, backend: :twilight
route '/bayriffer/collections', status: 200, backend: :twilight
route '/hrkchannel/collections', status: 200, backend: :twilight
route '/khobsanam/collections', status: 200, backend: :twilight
route '/riotgames/collections', status: 200, backend: :twilight
route '/rubsarb/collections', status: 200, backend: :twilight
route '/status.json', status: 200, backend: :legacy
route '/ember_deps.js', status: 200, backend: :legacy
route '/favicon.ico', status: 200, backend: :twilight
route '/live', status: 301, location: 'https://www.twitch.tv', backend: :legacy
route '/settings', status: 200, backend: :legacy
route '/settings/channel', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fsettings%2Fchannel', backend: :legacy
route '/settings/connections', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fsettings%2Fconnections', backend: :legacy
route '/settings/notifications', status: 200, backend: :twilight
route '/settings/prime', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fsettings%2Fprime', backend: :legacy
route '/settings/profile', status: 200, backend: :legacy
route '/settings/security', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fsettings%2Fsecurity', backend: :legacy
route '/settings/subscriptions', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fsettings%2Fsubscriptions', backend: :legacy
route '/settings/turbo', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fsettings%2Fturbo', backend: :legacy
route '/activate', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Factivate', backend: :legacy
route '/apple-touch-icon.png', status: 200, backend: :s3
route '/cohhcarnage/mobile', status: 302, location: 'https://m.twitch.tv/cohhcarnage', backend: :legacy
route '/day9tv/mobile', status: 302, location: 'https://m.twitch.tv/day9tv', backend: :legacy
route '/fxckzz199/mobile', status: 302, location: 'https://m.twitch.tv/fxckzz199', backend: :legacy
route '/killingteam/mobile', status: 302, location: 'https://m.twitch.tv/killingteam', backend: :legacy
route '/android', status: 301, location: 'https://play.google.com/store/apps/details?id=tv.twitch.android.viewer', backend: :legacy
route '/.well-known/apple-app-site-association', status: 200, backend: :s3
route '/apple-app-site-association', status: 200, backend: :s3
route '/experiments.json', status: 200, backend: :s3
route '/running', status: 200, backend: :legacy, skip_backend_check: true
route '/diresqrl/dashboard/subscription/game-commerce', status: 200, backend: :legacy
route '/inventory', status: 200, backend: :legacy
route '/directory/game/Cuphead/details', status: 200, backend: :twilight
route '/diresqrl/dashboard/subscription/ads', status: 200, backend: :legacy
route '/diresqrl/dashboard/subscription/video', status: 200, backend: :legacy
route '/bits/config.json', status: 404, backend: :legacy
route '/blizzheroes/esports/hgc-2017', status: 200, backend: :legacy
route '/evenmatchupgaming/subscribe', status: 302, location: 'https://www.twitch.tv/products/evenmatchupgaming/ticket', backend: :legacy
route '/meleeeveryday/subscribe', status: 302, location: 'https://www.twitch.tv/products/meleeeveryday/ticket', backend: :legacy
route '/pink_sparkles/subscribe', status: 302, location: 'https://www.twitch.tv/products/pink_sparkles/ticket', backend: :legacy
route '/simpleflips/subscribe', status: 302, location: 'https://www.twitch.tv/products/simpleflips/ticket', backend: :legacy
route '/tyrannasauruslex/subscribe', status: 302, location: 'https://www.twitch.tv/products/tyrannasauruslex/ticket', backend: :legacy
route '/vgbootcamp/subscribe', status: 302, location: 'https://www.twitch.tv/products/vgbootcamp/ticket', backend: :legacy
route '/diresqrl/dashboard/subscription', status: 200, backend: :legacy
route '/diresqrl/dashboard/subscription/badges', status: 200, backend: :legacy
route '/diresqrl/dashboard/subscription/chat', status: 200, backend: :legacy
route '/diresqrl/dashboard/subscription/chatperks', status: 200, backend: :legacy
route '/diresqrl/dashboard/subscription/creative', status: 200, backend: :legacy
route '/diresqrl/dashboard/subscription/ticket', status: 200, backend: :legacy
route '/diresqrl/dashboard/subscription/view-terms', status: 200, backend: :legacy
route '/diresqrl/dashboard/subscription/cheer', status: 200, backend: :legacy
route '/diresqrl/dashboard/subscription/cheerbadges', status: 200, backend: :legacy
route '/diresqrl/dashboard/subscription/cheermotes', status: 200, backend: :legacy
route '/products/geekandsundry/ticket', status: 200, backend: :legacy
route '/products/pink_sparkles/ticket', status: 200, backend: :legacy
route '/products/ratsmah/ticket', status: 200, backend: :legacy
route '/products/turbo', status: 200, backend: :legacy
route '/products/turbo/ticket', status: 200, backend: :legacy
route '/products/bits/ad', status: 200, backend: :twilight
route '/subscriptions', status: 200, backend: :legacy
route '/turbo', status: 301, location: 'https://www.twitch.tv/products/turbo', backend: :legacy
route '/directory/game/Paladins/details', status: 200, backend: :twilight
route '/directory/game/Smite/details', status: 200, backend: :twilight
route '/directory/game/Warframe/details', status: 200, backend: :twilight
route '/store/merch', status: 200, backend: :twilight
route '/store', status: 200, backend: :twilight
route '/diresqrl/dashboard/subscription/payout-onboarding', status: 200, backend: :legacy
route '/diresqrl/dashboard/subscription/payouts', status: 200, backend: :legacy
route '/store/games', status: 200, backend: :cloudfront
route '/store/games/assets/fonts/korolev-medium.otf', status: 200, backend: :cloudfront
route '/store/games/assets/images/bg-pattern.png', status: 200, backend: :cloudfront
route '/store/games/assets/images/oval.png', status: 200, backend: :cloudfront
route '/store/games/assets/images/platforms-twitch-desktop-app.jpg', status: 200, backend: :cloudfront
route '/store/games/assets/main.css', status: 200, backend: :cloudfront
route '/diresqrl/settings', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fdiresqrl%2Fsettings', backend: :legacy
route '/diresqrl/settings/streamkey', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fdiresqrl%2Fsettings%2Fstreamkey', backend: :legacy
route '/diresqrl/manager/clips', status: 200, backend: :legacy
route '/r/l/email_click/eyJjb250ZW50IjoiMjAxNjAzMTVjcmVhdGl2ZSIsIm1lZGl1bSI6InR3aXRjaGJsb2ciLCJwYXRoIjoiL2Zvb2QifQ==/c3cc57a596307e440cef06518aba58dd71da5968/food', status: 302, location: 'https://www.twitch.tv/', backend: :legacy
route '/r/l/email_click/eyJjb250ZW50IjoiMjAxNjAzMTVjcmVhdGl2ZSIsIm1lZGl1bSI6InR3aXRjaGJsb2ciLCJwYXRoIjoiL3NjZW5lb2ZhY3Rpb25tdXNpYyJ9/9356784c99eb74bbf2f9574cd3aa29f29d25b5d0/sceneofactionmusic', status: 302, location: 'https://www.twitch.tv/', backend: :legacy
route '/r/l/related_channel_click/eyJyZWZlcnJlciI6Im5pcGdhbWluZ3R2Iiwic291cmNlIjoiZ2FtZSJ9/3f0168e8a760952a50a44664975cd40d8c8841b8/kqly', status: 302, location: 'https://www.twitch.tv/', backend: :legacy
route '/r/l/related_channel_click/eyJyZWZlcnJlciI6ImJha2VybGl2ZSIsInNvdXJjZSI6ImdhbWUifQ==/630b514d7258d3ec61123ba91af8aa9307ff6db2/eillax', status: 302, location: 'https://www.twitch.tv/', backend: :legacy
route '/r/l/related_channel_click/eyJyZWZlcnJlciI6InRha2V0diIsInNvdXJjZSI6ImdhbWUifQ==/2054a320a898ac146336c0f9ed0b6a204fe3f596/welmu1', status: 302, location: 'https://www.twitch.tv/', backend: :legacy
route '/r/l/related_channel_click/eyJzb3VyY2UiOiJnYW1lIiwicmVmZXJyZXIiOiJlc2xiZW5lbHV4In0=/98ba6a2822c8c21ad0ae763dda41c6da3a37ce54/kungentv', status: 302, location: 'https://www.twitch.tv/', backend: :legacy
route '/aga191919/clips', status: 200, backend: :twilight
route '/drdisrespectlive/clips', status: 200, backend: :twilight
route '/mitchjones/clips', status: 200, backend: :twilight
route '/reckful/clips', status: 200, backend: :twilight
route '/sodapoppin/clips', status: 200, backend: :twilight
route '/stpeach/clips', status: 200, backend: :twilight
route '/directory/game/Counter-Strike%3A%20Global%20Offensive/clips', status: 200, backend: :twilight
route '/directory/game/Dota%202/clips', status: 200, backend: :twilight
route '/directory/game/Hearthstone/clips', status: 200, backend: :twilight
route '/directory/game/IRL/clips', status: 200, backend: :twilight
route "/directory/game/PLAYERUNKNOWN'S%20BATTLEGROUNDS/clips", status: 200, backend: :twilight
route '/directory/game/League%20of%20Legends/clips', status: 200, backend: :twilight
route '/directory/game/Dota%202/videos/all', status: 200, backend: :twilight
route '/directory/game/Dragon%20Ball%20Online/videos/all', status: 200, backend: :twilight
route '/directory/game/League%20of%20Legends/videos/all', status: 200, backend: :twilight
route '/directory/game/S.K.I.L.L.:%20Special%20Force%202/videos/all', status: 200, backend: :twilight
route '/directory/game/Star%20Wars:%20Battlefront%20II/videos/all', status: 200, backend: :twilight
route '/directory/videos', status: 200, backend: :twilight
route '/directory/videos/all', status: 200, backend: :twilight
route '/directory/videos/highlights', status: 200, backend: :twilight
route '/directory/videos/month', status: 200, backend: :twilight
route '/directory/videos/past-broadcasts', status: 200, backend: :twilight
route '/directory/videos/week', status: 200, backend: :twilight
route '/manager/clips', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fmanager%2Fclips', backend: :legacy
route '/adamkoebel/events', status: 200, backend: :twilight
route '/riotgames/events', status: 200, backend: :twilight
route '/time_of_chaos/events', status: 200, backend: :twilight
route '/twitch/events', status: 200, backend: :twilight
route '/vgbootcamp/events', status: 200, backend: :twilight
route '/wearethevr/events', status: 200, backend: :twilight
route '/riotgames/followers', status: 200, backend: :legacy
route '/shroud/followers', status: 200, backend: :legacy
route '/summit1g/followers', status: 200, backend: :legacy
route '/xliverobot/followers', status: 200, backend: :legacy
route '/blackufa_twitch/following', status: 200, backend: :legacy
route '/overwatchcontenders/following', status: 200, backend: :legacy
route '/riotgames/following', status: 200, backend: :legacy
route '/shroud/following', status: 200, backend: :legacy
route '/silvername/following', status: 200, backend: :legacy
route '/cinnamontoastken/p/d9957fb9-03ea-4a05-9056-3a2ee6641f20', status: 200, backend: :twilight
route '/jackpattillo/p/b2f0c018-7ca9-4e29-b5ca-48f0b5acbf69', status: 200, backend: :twilight
route '/jimlee/p/5cd0fc3d-d5b3-41f6-aec6-8db3aca0fa41', status: 200, backend: :twilight
route '/diresqrl/dashboard/events', status: 200, backend: :legacy
route '/directory', status: 200, backend: :twilight
route '/directory/creative', status: 200, backend: :twilight
route '/directory/discover', status: 200, backend: :twilight
route '/directory/following', status: 200, backend: :twilight
route '/directory/following/communities', status: 200, backend: :twilight
route '/directory/following/games', status: 200, backend: :twilight
route '/directory/following/hosts', status: 200, backend: :twilight
route '/directory/following/live', status: 200, backend: :twilight
route '/directory/game/Dota%202', status: 200, backend: :twilight
route '/directory/game/Dota%202/ru', status: 200, backend: :twilight
route '/directory/game/Hearthstone', status: 200, backend: :twilight
route '/directory/game/IRL', status: 200, backend: :twilight
route '/directory/game/League%20of%20Legends', status: 200, backend: :twilight
route '/directory/game/League%20of%20Legends/es', status: 200, backend: :twilight
route '/directory/game/League%20of%20Legends/pt', status: 200, backend: :twilight
route '/directory/game/League%20of%20Legends/tr', status: 200, backend: :twilight
route '/directory/game/League%20of%20Legends/zh', status: 200, backend: :twilight
route '/directory/game/Overwatch', status: 200, backend: :twilight
route "/directory/game/PLAYERUNKNOWN'S%20BATTLEGROUNDS", status: 200, backend: :twilight
route '/directory/game/World%20of%20Tanks/ru', status: 200, backend: :twilight
route '/directory/game/Dota%202/live', status: 200, backend: :twilight
route '/directory/game/RuneScape/live', status: 200, backend: :twilight
route '/directory/game/World%20of%20Warcraft:%20Mists%20of%20Pandaria/live', status: 200, backend: :twilight
route '/directory/all', status: 200, backend: :twilight
route '/directory/all/fr', status: 200, backend: :legacy
route '/directory/all/ru', status: 200, backend: :legacy
route '/directory/random', status: 301, location: 'https://www.twitch.tv/directory', backend: :legacy
route '/event/pax/live_member_list', status: 200, backend: :legacy
route '/search', status: 301, location: 'https://www.twitch.tv/', backend: :legacy
route '/freesports222/chat', status: 200, backend: :legacy
route '/gentichatnfl/chat', status: 200, backend: :legacy
route '/killfrenz/chat', status: 200, backend: :legacy
route '/shadbasemurdertv/chat', status: 200, backend: :legacy
route '/twitchpresents/chat', status: 200, backend: :legacy
route '/vgbootcamp/chat', status: 200, backend: :legacy
route '/diresqrl', status: 200, backend: :twilight
route '/diresqrl/outbox', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fdiresqrl%2Foutbox', backend: :legacy
route '/chat/embed?channel=itmejp', status: 302, location: 'https://www.twitch.tv/embed/itmejp/chat', backend: :legacy
route '/chat/embed?channel=lirik', status: 302, location: 'https://www.twitch.tv/embed/lirik/chat', backend: :legacy
route '/chat/embed?channel=twitchpresents', status: 302, location: 'https://www.twitch.tv/embed/twitchpresents/chat', backend: :legacy
route '/communities/failyv', status: 200, backend: :twilight
route '/communities/gamedevelopment', status: 200, backend: :twilight
route '/communities/music', status: 200, backend: :twilight
route '/communities/programming', status: 200, backend: :twilight
route '/communities/speedrunning', status: 200, backend: :twilight
route '/communities', status: 301, location: 'https://www.twitch.tv/directory/communities', backend: :legacy
route '/diresqrl/dashboard/moderation', status: 200, backend: :twilight
route '/directory/communities', status: 200, backend: :twilight
route '/dmca/login', status: 200, backend: :legacy
route '/dmca/sent', status: 302, location: 'https://www.twitch.tv/dmca/login', backend: :legacy
route '/dmca/takedown', status: 302, location: 'https://www.twitch.tv/dmca/login', backend: :legacy
route '/following', status: 301, location: 'https://www.twitch.tv/directory/following', backend: :legacy
route '/friends', status: 200, backend: :legacy
route '/friends/requests', status: 200, backend: :legacy
route '/bug_reports/new', status: 302, location: 'https://help.twitch.tv/customer/portal/emails/new', backend: :legacy
route '/contact', status: 302, location: 'https://help.twitch.tv/customer/portal/emails/new', backend: :legacy
route '/help', status: 302, location: 'https://help.twitch.tv/customer/portal/emails/new', backend: :legacy
route '/desk/multipass', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fdesk%2Fmultipass', backend: :legacy
route '/inbox', status: 301, location: 'https://www.twitch.tv/messages/inbox', backend: :legacy
route '/tmilibs/JSSocket.r87d5ce36f728d05d6dd7726f53841fa72b521499.swf', status: 200, backend: :legacy, skip_backend_check: true
route '/tmilibs/JSSocket.swf', status: 302, location: 'JSSocket.r87d5ce36f728d05d6dd7726f53841fa72b521499.swf', backend: :legacy, skip_backend_check: true
route '/message/compose', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fmessage%2Fcompose', backend: :legacy
route '/message/list', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fmessage%2Flist', backend: :legacy
route '/messages/inbox', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fmessages%2Finbox', backend: :legacy
route '/messages/other', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fmessages%2Fother', backend: :legacy
route '/messages/outbox', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fmessages%2Foutbox', backend: :legacy
route '/outbox', status: 301, location: 'https://www.twitch.tv/messages/outbox', backend: :legacy
route '/tmilibs/tmi-v3.js', status: 302, location: 'tmi-v3.ra99a30167cc0b7ea117bfaa34870530558fdba84.js', backend: :legacy, skip_backend_check: true
route '/tmilibs/tmi-v3.ra99a30167cc0b7ea117bfaa34870530558fdba84.js', status: 200, backend: :legacy, skip_backend_check: true
route '/tmilibs/tmi-v3.radc7182b2bb2a7e67d54e64a5312048ee1f9ebda.js', status: 302, location: 'tmi-v3.ra99a30167cc0b7ea117bfaa34870530558fdba84.js', backend: :legacy, skip_backend_check: true
route '/robots.txt', status: 200, backend: :twilight
route '/assets/application-9d1e12c7e657f718ede7137696fab963.js', status: 200, backend: :legacy, skip_backend_check: true
route '/assets/bootstrap_ember_component-670f42d6113ab407a90847b290a5f45a.js', status: 200, backend: :legacy, skip_backend_check: true
route '/assets/emberhelper-4674cf177d55f8a9cc492ee96ef3cdf0.js', status: 200, backend: :legacy, skip_backend_check: true
route '/assets/mobileRedirect-5d8df2504465e46617d2fd12d170bd2a.js', status: 200, backend: :legacy, skip_backend_check: true
route '/assets/pages/settings/index-323e23f21130513d51c11e87bb398bea.js', status: 406, backend: :legacy, skip_backend_check: true
route '/images/xarth/pages/error/error_castle.png', status: 200, backend: :legacy, skip_backend_check: true
route '/year/2014', status: 200, backend: :legacy
route '/year/2015', status: 200, backend: :legacy
route '/year/2016/', status: 200, backend: :cloudfront
route '/year/2016/assets/css/styles.min.css', status: 200, backend: :cloudfront
route '/year/2016/assets/favicon/favicon.ico', status: 200, backend: :cloudfront
route '/year/2016/assets/js/app.min.js', status: 200, backend: :cloudfront
route '/year/2016/assets/js/vendor/clipboard.min.js', status: 200, backend: :cloudfront
route '/year/2016/assets/js/vendor/jquery.keydrown.min.js', status: 200, backend: :cloudfront
route '/kraken/oauth2/authorization/120174', status: 400, backend: :legacy
route '/kraken/oauth2/authorization/122050', status: 400, backend: :legacy
route '/kraken/oauth2/authorization/17693', status: 400, backend: :legacy
route '/kraken/oauth2/authorization/34523', status: 400, backend: :legacy
route '/kraken/oauth2/authorization/71962', status: 400, backend: :legacy
route '/kraken/oauth2/authorization/80183', status: 400, backend: :legacy
route '/diresqrl/dashboard/extensions', status: 200, backend: :legacy
route '/diresqrl/dashboard/permissions', status: 200, backend: :legacy
route '/diresqrl/dashboard/settings', status: 200, backend: :legacy
route '/ext/24u62kim5mn0slhwigdt7v4ybkwef5-1.0.3', status: 200, backend: :legacy
route '/ext/4ntuott0zqw008atk0wy60phfa8jyf-0.0.9', status: 200, backend: :legacy
route '/ext/h7683cdyci11yov0tlac9f6lkvgtzi-0.0.5', status: 200, backend: :legacy
route '/ext/wi08ebtatdc7oj83wtl9uxwz807l8b', status: 200, backend: :legacy
route '/ext/zfh2irvx2jb4s60f02jq0ajm8vwgka', status: 200, backend: :legacy
route '/ext/zfh2irvx2jb4s60f02jq0ajm8vwgka-1.0.12', status: 200, backend: :legacy
route '/login', status: 302, location: 'https://passport.twitch.tv/sessions/new', backend: :legacy
route '/logout', status: 301, location: 'https://www.twitch.tv/', backend: :legacy
route '/logins/new', status: 301, location: 'https://passport.twitch.tv/logins/new', backend: :legacy
route '/passport/callback', status: 404, backend: :legacy
route '/signup', status: 302, location: 'https://passport.twitch.tv/signup/new', backend: :legacy
route '/yt/pokimane', status: 200, backend: :legacy
route '/yt/riotgames', status: 200, backend: :legacy
route '/yt/summit1g', status: 200, backend: :legacy
route '/yt/summonersinnlive', status: 200, backend: :legacy
route '/yt/terracid', status: 200, backend: :legacy
route '/yt/totalbiscuit', status: 200, backend: :legacy
route '/event/pax', status: 200, backend: :legacy
route '/event/twitchcon', status: 200, backend: :legacy
route '/event/twitchcon/live_member_list', status: 200, backend: :legacy
route '/events/112116', status: 200, backend: :twilight
route '/events/123107', status: 200, backend: :twilight
route '/events/123120', status: 200, backend: :twilight
route '/events/123123', status: 200, backend: :twilight
route '/events/123124', status: 200, backend: :twilight
route '/events/81117', status: 200, backend: :twilight
route '/p/watch/anime', status: 200, backend: :cloudfront
route '/watch/anime', status: 301, location: 'https://www.twitch.tv/p/watch/anime', backend: :cloudfront
route '/lirik', status: 200, backend: :twilight
route '/reckful', status: 200, backend: :twilight
route '/riotgames', status: 200, backend: :twilight
route '/rocketleague', status: 200, backend: :twilight
route '/shroud', status: 200, backend: :twilight
route '/summit1g', status: 200, backend: :twilight
route '/partner/signup', status: 200, backend: :legacy
route '/p/partners', status: 200, backend: :cloudfront
