# frozen_string_literal: true

require 'concurrent/array'
require 'twitch/audit/worker'

module Twitch
  module Audit

    # A client that wil queue messages to be written to the service endpoint
    class Client

      # The in memory queue for batched processing
      # @return [Concurrent::Array]
      attr_reader :queue

      # @param [Twitch::Audit::ClientConfiguration] config
      def initialize(config)
        @queue = Concurrent::Array.new
        @worker = Worker.new(config, queue)
      end

      # @param [Twitch::Audit::LogEntry] message
      # @return [void]
      def enqueue(message)
        queue.push(message)
      end
    end
  end
end
