# frozen_string_literal: true

require 'json'
require 'awrence'

Awrence.acronyms = { 'uid' => 'UID', 'ip' => 'IP' }

module Twitch
  module Audit
    module Mixins
      # A simple mixin to handle conversion of Dry::Struct instances to JSON
      module Jsonify

        # Parses a object to json after converting the hash keys to camel case keys
        # @return [String]
        def to_json(*args)
          to_h.to_camelback_keys.to_json(*args)
        end
      end
    end
  end
end
