# frozen_string_literal: true

require 'dry/struct'
require 'twitch/audit/mixins/jsonify'
require 'twitch/audit/models/types'

module Twitch
  module Audit

    # Data model representing a chunk of data changed.  Think of this like a state differential
    class DataChange < Dry::Struct
      include Mixins::Jsonify

      # @!attribute [rw]
      # The original serialized state of the changed data
      # @return [String]
      attribute :before, Types::Strict::String

      # @!attribute [rw]
      # The new serialized state of the changed, or attempted to be changed, data
      # @return [String]
      attribute :after, Types::Strict::String

      # @!attribute [rw]
      # Was this a valid way to change the data?
      # @return [Boolean]
      attribute :valid, Types::Strict::Bool.default(false)

    end
  end
end
