# frozen_string_literal: true

require 'dry-types'
require 'netaddr'

module Twitch
  module Audit
    # @private
    # Types boilerplate for our structured data
    module Types
      include Dry::Types.module


      SubnetArray = Types::Strict::Array.of(Types.Instance(NetAddr::CIDR) | Types::Strict::String.constrained(
        format: %r(^\d{1,3}(?:\.\d{1,3}){0,3}(?:/\d{1,2})?$)
      ))
    end
  end
end
