# frozen_string_literal: true

module Twitch
  module Audit
    # Provides a request-local storage mechanism for log entries
    class RequestContext
      class << self

        # Yields the current log entry partial for data population.
        # @return [Twitch::Audit::LogEntry]
        def hydrate_entry
          yield log_entry
        end

        # Lazily instantiates a new LogEntry partial
        # @return [Twitch::Audit::LogEntry]
        def log_entry
          Thread.current[:twitch_audit_log_entry] ||= LogEntry.partial
        end

        # Tests if there's a pending log entry
        # @return [Boolean]
        def log_entry?
          !Thread.current[:twitch_audit_log_entry].nil?
        end

        # Resets the state for the current thread
        # @return [void]
        def reset
          Thread.current[:twitch_audit_log_entry] = nil
        end
      end
    end
  end
end
