# frozen_string_literal: true

require 'concurrent/array'
require 'twitch/audit/models/client_configuration'
require 'twitch/audit/worker'

describe Twitch::Audit::Worker do
  let(:config) do
    Twitch::Audit::ClientConfiguration.new(
      dead_letter_bucket: 'test-bucket',
      service_name: 'Twitch Audit Testing',
      sns_topic_arn: 'arn:aws:sns:us-west-2:123456789012:test-sns'
    )
  end

  subject(:worker) { described_class.new(config, Concurrent::Array.new) }

  context 'when creating an instance' do
    it('has valid state') do
      expect(worker.config).to be_an_instance_of(Twitch::Audit::ClientConfiguration)
      expect(worker.queue).to be_an_instance_of(Concurrent::Array)
      expect(worker.task).to be_an_instance_of(Concurrent::TimerTask)
    end
  end

  context 'when the queue is empty' do
    it('reports zero queue entries') { expect(worker.queue.length).to equal(0) }
    it('batch processing does not try to process entries') do
      expect(worker).to_not receive(:process_entry)
      worker.process_batch
    end
  end

  context 'when processing an entry' do

  end
end
