# frozen_string_literal: true

lib = File.expand_path('lib', __dir__)
$LOAD_PATH.unshift(lib) unless $LOAD_PATH.include?(lib)

require 'twitch/audit/version'

Gem::Specification.new do |spec|
  # protect against an accidental release
  raise 'RubyGems 2.0 or newer is required to protect against public gem pushes.' unless spec.respond_to?(:metadata)

  spec.metadata['allowed_push_host'] = 'https://gem.pkgs.xarth.tv'

  # configure the gem
  spec.name          = 'twitch-audit'
  spec.version       = Twitch::Audit::VERSION
  spec.authors       = ['Bryan McLemore']
  spec.email         = ['mclemore@justin.tv']

  spec.summary       = 'Provides a client library to submit audit log messages.'
  spec.description   = 'Provides a client library to submit audit log messages.'
  spec.homepage      = 'https://git-aws.internal.justin.tv/CPE-Ops/twitch-audit'
  spec.license       = 'Nonstandard' # All Rights Reserved

  spec.files         = `git ls-files -z`.split("\x0").reject { |f| f.match '^(bin|lambdas|test)' }
  spec.bindir        = 'exe'
  spec.executables   = []
  spec.require_paths = ['lib']

  spec.add_dependency 'awrence', '~> 1.0'
  spec.add_dependency 'aws-sdk-s3', '~> 1.30'
  spec.add_dependency 'aws-sdk-sns', '~> 1.9'
  spec.add_dependency 'concurrent-ruby', '~> 1.0.0'
  spec.add_dependency 'concurrent-ruby-ext', '~> 1.0.0'
  spec.add_dependency 'dry-struct', '~> 0.6'
  spec.add_dependency 'json', '~> 2.1'
  spec.add_dependency 'netaddr', '~> 1.5'
  spec.add_dependency 'rack', '~> 2.0'

  spec.add_development_dependency 'bundler', '~> 1.17'
  spec.add_development_dependency 'geminabox-release', '~> 1.2'
  spec.add_development_dependency 'pry', '~> 0.10'
  spec.add_development_dependency 'rake', '~> 12.3'
  spec.add_development_dependency 'rspec', '~> 3.8'
  spec.add_development_dependency 'rubocop', '~> 0'
  spec.add_development_dependency 'should_not', '~> 1.1'
  spec.add_development_dependency 'simplecov', '~> 0.14'
  spec.add_development_dependency 'yard', ' ~> 0'
end
