def log(message)
  puts "##teamcity[message text='#{message}']"
end

def set_param(key, value)
  puts "##teamcity[setParameter name='#{key}' value='#{value}']"
end

def pretty_region(region)
  parts = region.to_s.split('-')
  "#{parts[0].upcase}#{parts[1].capitalize}#{parts[2]}"
end

def regionalized_role(base, region)
  return base unless base =~ /^.*-(.*)-.*$/
  parts = base.split('-')
  "#{parts[0]}-#{pretty_region(region)}-#{parts[2]}"[0..62]
end