import jetbrains.buildServer.configs.kotlin.v2018_2.ParameterDisplay
import jetbrains.buildServer.configs.kotlin.v2018_2.ReuseBuilds
import jetbrains.buildServer.configs.kotlin.v2018_2.buildSteps.exec
import jetbrains.buildServer.configs.kotlin.v2018_2.buildSteps.script
import jetbrains.buildServer.configs.kotlin.v2018_2.version
import twitch.instrumentorum.enums.AWSRegion
import twitch.instrumentorum.enums.BranchFilter
// to download instrumentorum as a maven dependency, you will need to be on TwitchVPN
import twitch.instrumentorum.instrum
import twitch.instrumentorum.project.builds.dockerAwareBuild
import twitch.instrumentorum.project.builds.dockerBuildAndPush
import twitch.instrumentorum.project.builds.initializeBuildChain
import twitch.instrumentorum.project.builds.updateECSService
import twitch.instrumentorum.project.steps.verifyECRRepository

// specify the TeamCity DSL version
version = "2018.2"

instrum {
    description = "Mid-Tier Cache for Mobile Web Static Assets"

    sourceRoot("git@git-aws.internal.justin.tv:CPE-Ops/vicarius.git")
    settingsRoot("git@git-aws.internal.justin.tv:CPE-Ops/vicarius-mweb-ci.git")

    textParam("git.branch.default", "refs/heads/mobile_web", "Default Git Branch", "Default Git Branch")
    textParam("ecr.repo", "vicarius-mweb", "ECR Repository", "The name of the ECR Repository used for deploys")

    // initializeBuildChain creates a BuildType that performs common, sane steps to help with identifying builds
    initializeBuildChain {}

    dockerBuildAndPush("Build") {
        paramFrom("Initialize Build Chain", "git.commit.short")

        vcsTrigger {
            branchFilter = """
                +:<default>
            """.trimIndent()
        }
    }

    subInstrum("Staging Deploy", "Staging") {
        updateECSService("Deploy to Staging Environment") {
            paramFrom("Initialize Build Chain", "git.commit.short")

            // auto-triggers for master only
            vcsTrigger {
                branchFilter = """
                    +:<default>
                """.trimIndent()
            }

            ecsAccountId = "709603242682"
            ecsCluster = "services"
            ecsService = "vicarius_mweb"

            deployRole = "TeamcityToECSIAMRole-USWest2-a8c2cb91588648a68930a6cc0e092be018"

            failureConditions {
                executionTimeoutMin = 5 // fail if deploy goes longer than 5 minutes
            }

            maxRunningBuilds = 1

            updateRegion(AWSRegion.PDX, "tasks/vicarius.staging.json", 1)
        }
    }

    subInstrum("Production Deploy", "Production") {
        textParam("git.branch.spec", "+:refs/heads/(mobile_web)", "Branch Spec", "What branches should we additionally watch or ignore?", display = ParameterDisplay.HIDDEN)

        updateECSService("Deploy to Production Environment") {
            paramFrom("Initialize Build Chain", "git.commit.short")

            snapshotDependency("Build")

            maxRunningBuilds = 1

            ecsAccountId = "015957721237"
            ecsCluster = "services"
            ecsService = "vicarius_mweb"

            deployRole = "TeamcityToECSIAMRole-USWest2-a8c2cb91588648a68930a6cc0e092be018"

            steps {
                script {
                    name = "Filter Non-Master Deploys"
                    scriptContent = """
                        #!/usr/bin/env bash
                        if [ "%teamcity.build.branch%" != "mobile_web" ]; then
                            echo ##teamcity[buildProblem description='Production is reserved for "mobile_web" releases only']
                        fi
                    """.trimIndent()
                }
            }

            updateRegion(AWSRegion.PDX, "tasks/production/vicarius.production.pdx.json", 2)
            updateRegion(AWSRegion.CLE, "tasks/production/vicarius.production.cle.json", 2)
            updateRegion(AWSRegion.SIN, "tasks/production/vicarius.production.sin.json", 2)
        }
    }
}