#!/usr/bin/env ruby

require 'json'

data = `aws sts assume-role --role-arn arn:aws:iam::015957721237:role/CPE-Admin --role-session-name vicarius-development --profile twitch-tachyon`

credentials = JSON.parse(data)['Credentials']

headers = {
  'X-Access-Key': credentials['AccessKeyId'],
  'X-Secret-Key': credentials['SecretAccessKey'],
  'X-Session-Token': credentials['SessionToken']
}

headers = headers.collect { |k, v| "-H '#{k}: #{v}'" }.join(' ')
status = `curl -s -w "%{http_code}" -o /dev/null -XSETTINGS #{headers} http://127.0.0.1:80`

puts "Attempted to update access keys; received a #{status} response."
