# frozen_string_literal: true

# Global mapping of shorthand codes to AWS regions
AWS_REGIONS = {
  nrt: 'ap-northeast-1',
  icn: 'ap-northeast-2',
  bom: 'ap-south-1',
  sin: 'ap-southeast-1',
  syd: 'ap-southeast-2',
  yul: 'ca-central-1',
  fra: 'eu-central-1',
  dub: 'eu-west-1',
  lhr: 'eu-west-2',
  gru: 'sa-east-1',
  iad: 'us-east-1',
  cle: 'us-east-2',
  sjc: 'us-west-1',
  pdx: 'us-west-2'
}.freeze

ORIGIN_ENVS = {
  production: {
    nrt: :icn,
    icn: :icn,
    bom: :icn,
    sin: :icn,
    syd: :icn,
    yul: :iad,
    fra: :fra,
    dub: :fra,
    lhr: :fra,
    gru: :iad,
    iad: :iad,
    cle: :iad,
    sjc: :iad,
    pdx: :iad
  },
  shadow: {
    fra: :fra,
    gru: :gru,
    pdx: :pdx
  },
  test: {
    pdx: :pdx
  }
}

# common environment variables
AWS_ECR_URL                       = ENV['AWS_ECR_URL'].freeze
CLUSTER_NAME                      = ENV['CLUSTER_NAME'].freeze
DEPLOY_ASSUME_ROLE                = ENV['DEPLOY_ASSUME_ROLE'].freeze
DEPLOY_AWS_ACCOUNT                = ENV['DEPLOY_AWS_ACCOUNT'].freeze
DEPLOY_CLOUDWATCH_REGION          = AWS_REGIONS[ENV['DEPLOY_CLOUDWATCH_ENV'].to_sym].freeze
DEPLOY_ENV                        = ENV['DEPLOY_ENV'].split(',').map(&:strip).map(&:to_sym).freeze
DEPLOY_TIMEOUT                    = (ENV['DEPLOY_TIMEOUT'] || 300).to_i.freeze
DESIRED_COUNT                     = ENV['DESIRED_COUNT'].freeze
IMAGE_VERSION                     = ENV['IMAGE_VERSION'].freeze
SERVICE_NAME                      = ENV['SERVICE_NAME'].freeze
TASK_FAMILY                       = ENV['TASK_FAMILY'].freeze
TASK_ROLE                         = ENV['TASK_ROLE'].freeze
TEAMCITY_PROJECT_NAME             = ENV['IMAGE_NAME'].freeze

# logging service environment variables
VARNISH_CACHE_SIZE = ENV.fetch('VARNISH_CACHE_SIZE', '1792').freeze
VARNISH_TTL = ENV.fetch('VARNISH_TTL', '86400').freeze
VICARIUS_STAGE = ENV['VICARIUS_STAGE'].to_sym
