#!/bin/bash

# Start a minutely cron with supercronic.
(supercronic /vicarius/vicarius.crontab &)

# Output logs to std out.
(/usr/local/bin/varnishlog -g request -v &)
(/usr/local/bin/varnishncsa -g request  &)

# Get ready to update the key now.
(/vicarius/update_keys.rb &)

# Launch varnishd for this environment.
exec /usr/local/sbin/varnishd -f /vicarius/${VICARIUS_STAGE:-production}.${VICARIUS_ORIGIN_ENV:-fra}.vcl -F -s malloc,${VARNISH_CACHE_SIZE:-100}M -T 0.0.0.0:2000 -t ${VARNISH_TTL:-86400} -a 0.0.0.0:8080 -S none
