#!/bin/bash

declare -A ENVS
ENVS[production]="fra iad icn"
ENVS[shadow]="fra gru pdx"
ENVS[test]="pdx"

EXITCODE=0

echo "##teamcity[testSuiteStarted name='StaticTests']"
for VICARIUS_STAGE in "${!ENVS[@]}"; do
  for VICARIUS_ORIGIN_ENV in ${ENVS[$VICARIUS_STAGE]}; do
    echo "##teamcity[testStarted name='$VICARIUS_STAGE:$VICARIUS_ORIGIN_ENV']"
    OUTPUT=$(/usr/local/sbin/varnishd -C -f /vicarius/${VICARIUS_STAGE}.${VICARIUS_ORIGIN_ENV}.vcl \
                              -s malloc,${VARNISH_CACHE_SIZE:-100}M \
                              -T 0.0.0.0:2000 \
                              -t ${VARNISH_TTL:-86400} \
                              -a 0.0.0.0:8080 2>&1)
    if [ $? -ne 0 ]; then
      echo "##teamcity[testFailed name='$VICARIUS_STAGE:$VICARIUS_ORIGIN_ENV' details='$OUTPUT']"
      EXITCODE=1
    fi
    echo "##teamcity[testFinished name='$VICARIUS_STAGE:$VICARIUS_ORIGIN_ENV']"
  done
done

echo "##teamcity[testSuiteFinished name='StaticTests']"
exit $EXITCODE