#!/usr/bin/env ruby

require 'json'

data = `aws sts assume-role --role-arn arn:aws:iam::857171411193:role/TeamcityToECSIAMRole-USWest2-e8b21cc0c935a548f1355b96bd12dd5231 --role-session-name vicarius-testing`

credentials = JSON.parse(data)['Credentials']

headers = {
  'X-Access-Key': credentials['AccessKeyId'],
  'X-Secret-Key': credentials['SecretAccessKey'],
  'X-Session-Token': credentials['SessionToken']
}

headers = headers.collect { |k, v| "-H '#{k}: #{v}'" }.join(' ')
status = `curl -s -w "%{http_code}" -o /dev/null -XSETTINGS #{headers} http://varnish:8080`

puts "Attempted to update access keys; received a #{status} response."
