# frozen_string_literal: true

require 'faraday'
require 'faraday-cookie_jar'

require_relative 'constants'

module Twitch
  class Web
    class << self
      def create(protocol)
        Faraday.new("#{protocol}://www.twitch.tv") do |conn|
          conn.use :cookie_jar
          conn.adapter Faraday.default_adapter
        end
      end
    end
  end
end
