# frozen_string_literal: true

OT_ITERATIONS = ENV['OT_ITERATIONS'] ? ENV['OT_ITERATIONS'].to_i : 5
WRT_ITERATIONS = ENV['WRT_ITERATIONS'] ? ENV['WRT_ITERATIONS'].to_i : 200
MAX_DELTA = ENV['MAX_DELTA'] ? ENV['MAX_DELTA'].to_f : 0.015

DEFAULT_REDIRECT_CRITERIA = 1.00
AUTHENITCATED_REDIRECT_CRITERIA = 0.50

BOTS = [
  'rogerbot',
  'linkedinbot',
  'embedly',
  'quora link preview',
  'showyoubot',
  'outbrain',
  'pinterest',
  'slackbot',
  'vkShare',
  'W3C_Validator',
  'redditbot',
  'Applebot',
  'googlebot',
  'mediapartners-google',
  'google favicon',
  'yahoo',
  'bingbot',
  'yandexbot',
  'sideqik',
  'seznambot',
  'mail.ru_bot',
  'baiduspider',
  'Facebot',
  'Twitterbot',
  'facebookexternalhit',
  'facebookexternalhit/1.1'
].freeze

SAFARI_11_USER_AGENTS = [
  '(KHTML, like Gecko) PhantomJS/2.1.1 Safari/538.1 Prerender (+https://github.com/prerender/prerender)', # NOT safari 11, but we shouldn't redirect for prerender.io
  'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_6) AppleWebKit/604.1.38 (KHTML, like Gecko) Version/11.0 Safari/604.1.38',
  # 'Mozilla/5.0 (iPhone; CPU iPhone OS 11_0 like Mac OS X) AppleWebKit/604.1.38 (KHTML, like Gecko) Version/11.0 Mobile/15A372 Safari/604.1',
  # 'Mozilla/5.0 (iPhone; CPU iPhone OS 11_0_1 like Mac OS X) AppleWebKit/604.1.38 (KHTML, like Gecko) Version/11.0 Mobile/15A402 Safari/604.1',
  'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13) AppleWebKit/604.1.38 (KHTML, like Gecko) Version/11.0 Safari/604.1.38',
  'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/604.1.38 (KHTML, like Gecko) Version/11.0 Safari/604.1.38',
  # 'Mozilla/5.0 (iPad; CPU OS 11_0 like Mac OS X) AppleWebKit/604.1.38 (KHTML, like Gecko) Version/11.0 Mobile/15A372 Safari/604.1',
  # 'Mozilla/5.0 (iPad; CPU OS 11_0_1 like Mac OS X) AppleWebKit/604.1.38 (KHTML, like Gecko) Version/11.0 Mobile/15A402 Safari/604.1',
  # 'Mozilla/5.0 (iPhone; CPU iPhone OS 11_0_2 like Mac OS X) AppleWebKit/604.1.38 (KHTML, like Gecko) Version/11.0 Mobile/15A421 Safari/604.1',
  # 'Mozilla/5.0 (iPhone; CPU iPhone OS 11_0 like Mac OS X) AppleWebKit/604.1.31 (KHTML, like Gecko) Version/11.0 Mobile/15A5327g Safari/604.1',
  # 'Mozilla/5.0 (iPhone; CPU iPhone OS 11_0 like Mac OS X) AppleWebKit/604.1.25 (KHTML, like Gecko) Version/11.0 Mobile/15A5304i Safari/604.1',
  # 'Mozilla/5.0 (iPhone; CPU iPhone OS 11_0 like Mac OS X) AppleWebKit/604.1.28 (KHTML, like Gecko) Version/11.0 Mobile/15A5318g Safari/604.1',
  # 'Mozilla/5.0 (iPhone; CPU iPhone OS 11_0 like Mac OS X) AppleWebKit/604.1.38 (KHTML, like Gecko) Version/11.0 Mobile/15A5362a Safari/604.1',
  # 'Mozilla/5.0 (iPhone; CPU iPhone OS 11_0 like Mac OS X) AppleWebKit/604.1.38 (KHTML, like Gecko) Version/11.0 Mobile/15A5354b Safari/604.1',
  # 'Mozilla/5.0 (iPhone; CPU iPhone OS 11_0 like Mac OS X) AppleWebKit/604.1.34 (KHTML, like Gecko) Version/11.0 Mobile/15A5341f Safari/604.1',
  # 'Mozilla/5.0 (iPhone; CPU iPhone OS 11_0 like Mac OS X) AppleWebKit/604.1.38 (KHTML, like Gecko) Version/11.0 Mobile/15A5372a Safari/604.1',
  'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13) AppleWebKit/604.1.25 (KHTML, like Gecko) Version/11.0 Safari/604.1.25',
  # 'Mozilla/5.0 (iPad; CPU OS 11_0 like Mac OS X) AppleWebKit/604.1.25 (KHTML, like Gecko) Version/11.0 Mobile/15A5304j Safari/604.1',
  'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13) AppleWebKit/604.1.31 (KHTML, like Gecko) Version/11.0 Safari/604.1.31',
  # 'Mozilla/5.0 (iPhone; CPU iPhone OS 11_0 like Mac OS X) AppleWebKit/604.1.38 (KHTML, like Gecko) Version/11.0 Mobile/15A5370a Safari/604.1',
  'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13) AppleWebKit/604.1.28 (KHTML, like Gecko) Version/11.0 Safari/604.1.28',
  # 'Mozilla/5.0 (iPad; CPU OS 11_0_2 like Mac OS X) AppleWebKit/604.1.38 (KHTML, like Gecko) Version/11.0 Mobile/15A421 Safari/604.1',
  # 'Mozilla/5.0 (iPhone; CPU iPhone OS 11_0 like Mac OS X) AppleWebKit/604.1.38 (KHTML, like Gecko) Version/11.0 Mobile/15A5368a Safari/604.1',
  # 'Mozilla/5.0 (iPad; CPU OS 11_0 like Mac OS X) AppleWebKit/604.1.25 (KHTML, like Gecko) Version/11.0 Mobile/15A5304i Safari/604.1',
  # 'Mozilla/5.0 (iPad; CPU OS 11_0 like Mac OS X) AppleWebKit/604.1.28 (KHTML, like Gecko) Version/11.0 Mobile/15A5318g Safari/604.1',
  'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_1) AppleWebKit/604.3.1 (KHTML, like Gecko) Version/11.0.1 Safari/604.3.1',
  # 'Mozilla/5.0 (iPhone; CPU iPhone OS 11_0 like Mac OS X) AppleWebKit/604.1.25 (KHTML, like Gecko) Version/11.0 Mobile/15A5304j Safari/604.1',
  'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_6) AppleWebKit/604.1.32 (KHTML, like Gecko) Version/11.0 Safari/604.1.32',
  # 'Mozilla/5.0 (iPhone; CPU iPhone OS 11_1 like Mac OS X) AppleWebKit/604.3.1 (KHTML, like Gecko) Version/11.0 Mobile/15B5066f Safari/604.1',
  'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13) AppleWebKit/604.1.34 (KHTML, like Gecko) Version/11.0 Safari/604.1.34',
  'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_6) AppleWebKit/604.1.28 (KHTML, like Gecko) Version/11.0 Safari/604.1.28',
  # 'Mozilla/5.0 (iPhone; CPU iPhone OS 11_0 like Mac OS X) AppleWebKit/602.2.8 (KHTML, like Gecko) Version/11.0 Mobile/14B55c Safari/602.1',
  # 'Mozilla/5.0 (iPhone; CPU iPhone OS 11_0 like Mac OS X) AppleWebKit/604.1.21 (KHTML, like Gecko) Version/11.0 Mobile/15A5278f Safari/602.1'
].freeze

PS4_USER_AGENT = 'Mozilla/5.0 (PlayStation 4 4.74) AppleWebKit/601.2 (KHTML, like Gecko)'

MOBILE_USER_AGENT = 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_0_1 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) Version/10.0 Mobile/14A403 Safari/602.1'

MOBILE_PATH_BLACKLIST = [
  { path: '/site_options.js', status: 200 },
  { path: '/tmilibs/tmi-v3.js', status: 302 },
  { path: '/tmilibs/tmi-v3.ra99a30167cc0b7ea117bfaa34870530558fdba84.js', status: 200 },
  { path: '/experiments.json', status: 200 },
  { path: '/assets/emberhelper-4674cf177d55f8a9cc492ee96ef3cdf0.js', status: 200 },
  { path: '/assets/mobileRedirect-5d8df2504465e46617d2fd12d170bd2a.js', status: 200 },
  { path: '/favicon.ico', status: 200 },
  { path: '/email-verification/abc123', status: 200 },
  { path: '/logout', status: 301 },
  { path: '/login', status: 302 },
  { path: '/desk/multipass', status: 302 },
  { path: '/partner/signup', status: 200 },
  { path: '/help', status: 302 },
  { path: '/apple-app-site-association', status: 200 },
  { path: '/.well-known/apple-app-site-association', status: 200 },
  { path: '/p/legal/privacy-policy', status: 200 },
  { path: '/legal/privacy-policy', status: 404 },
  { path: '/watch/anime', status: 301 },
  { path: '/about', status: 404 },
  { path: '/prime', status: 301 },
  { path: '/blog', status: 301 },
  { path: '/blog/123', status: 404 },
  { path: '/view', status: 301 },
  { path: '/view/123', status: 301 },
  { path: '/stream', status: 404 },
  { path: '/stream/123', status: 404 },
  { path: '/jobs', status: 301 },
  { path: '/jobs/', status: 301 },
  { path: '/gear-on-amazon', status: 301 }
].freeze

BETA_PATHS_REDIRECT = [
  '/',
  '/directory',
  '/directory/following',
  '/following',
  '/directory/game/PLAYERUNKNOWN\'S%20BATTLEGROUNDS',
  '/directory/game/PLAYERUNKNOWN\'S%20BATTLEGROUNDS/videos/all',
  '/directory/following/live',
  '/directory/following/hosts',
  '/directory/following/games',
  '/collections/HgO9Lc2mqhTTtw',
  '/videos/117022022',
  '/lirik',
  '/lirik/videos',
  '/lirik/videos/all',
  '/lirik/clips',
  '/store',
  '/store/merch',
  '/itmejp/collections',
  '/communities/varietystreaming',
].freeze

BETA_PATHS_NO_REDIRECT = [
  { path: '/site_options.js', status: 200 },
  { path: '/ember_deps.js', status: 200 },
  { path: '/tmilibs/tmi-v3.js', status: 302 },
  { path: '/tmilibs/tmi-v3.ra99a30167cc0b7ea117bfaa34870530558fdba84.js', status: 200 },
  { path: '/experiments.json', status: 200 },
  { path: '/assets/emberhelper-4674cf177d55f8a9cc492ee96ef3cdf0.js', status: 200 },
  { path: '/assets/mobileRedirect-5d8df2504465e46617d2fd12d170bd2a.js', status: 200 },
  { path: '/styles/application.css', status: 406 },
  { path: '/styles/phoenix.css', status: 406 },
  { path: '/global.js', status: 200 },
  { path: '/benchmark.js', status: 200 },
  { path: '/translations/en-us.js', status: 406 },
  { path: '/assets/intl/intl.complete.js', status: 406 },
  { path: '/favicon.ico', status: 200 },
  { path: '/logout', status: 301 },
  { path: '/p/legal/privacy-policy', status: 200 },
  { path: '/legal/privacy-policy', status: 404 },
  { path: '/store/games', status: 200 },
  { path: '/jobs', status: 301 },
  { path: '/jobs/', status: 301 },
  { path: '/directory/following/videos/all', status: 200 },
  { path: '/directory/following/communities', status: 200 },
  { path: '/directory/discover', status: 200 },
  { path: '/directory/communities', status: 200 },
  { path: '/directory/game/PLAYERUNKNOWN\'S%20BATTLEGROUNDS/en', status: 200 },
  { path: '/directory/game/PLAYERUNKNOWN\'S%20BATTLEGROUNDS/clips', status: 200 },
  { path: '/directory/creative', status: 200 },
  { path: '/directory/all', status: 200 },
  { path: '/directory/all/ps4', status: 200 },
  { path: '/directory/videos/all', status: 200 },
  { path: '/subscriptions', status: 200 },
  { path: '/broadcast', status: 200 },
  { path: '/broadcast/dashboard', status: 302 },
  { path: '/broadcast/dashboards', status: 302 },
  { path: '/lirik/streamplus', status: 200 },
  { path: '/lirik/chat', status: 200 },
  { path: '/lirik/v/110853493', status: 301 },
  { path: '/itmejp/events', status: 200 },
  { path: '/events/97315', status: 200 },
  { path: '/lirik/following', status: 200 },
  { path: '/lirik/followers', status: 200 },
  { path: '/lirik/popout', status: 302 },
  { path: '/lirik/embed', status: 302 },
  { path: '/lirik/mobile', status: 302 },
  { path: '/blizzheroes/esports/hgc-2017', status: 200 },
  { path: '/itmejp/clips/tubularrichwitchcurselit', status: 200 },
  { path: '/communities/create', status: 200 },
  { path: '/create', status: 200 },
  { path: '/pr/welcome', status: 301 },
  { path: '/products/bits/ad', status: 200 },
  { path: '/inventory', status: 200 },
  { path: '/diresqrl/report_form', status: 200 },
  { path: '/dmca/login', status: 200 },
  { path: '/email-verification/abc123', status: 200 },
  { path: '/yt/abc123', status: 200 },
  { path: '/streams/abc123', status: 404 },
  { path: '/dashboard', status: 301 },
  { path: '/dashboard/settings', status: 302 },
  { path: '/settings', status: 200 },
  { path: '/settings/profile', status: 200 },
  { path: '/ext', status: 200 },
  { path: '/ext/abc123', status: 200 },
  { path: '/friends', status: 200 },
  { path: '/friends/requests', status: 200 },
  { path: '/private/abc123', status: 404 },
  { path: '/diresqrl/manager', status: 301 },
  { path: '/diresqrl/manager/past_broadcasts', status: 200 },
  { path: '/popout', status: 200 },
  { path: '/communities', status: 301 },
  { path: '/desk/multipass', status: 302 },
  { path: '/gear-on-amazon', status: 301 },
  { path: '/partner/signup', status: 200 },
  { path: '/help', status: 302 },
  { path: '/live', status: 301 },
  { path: '/admin', status: 302 },
  { path: '/admin/dashboard', status: 302 },
  { path: '/running', status: 200 },
  { path: '/running/index', status: 200 },
  { path: '/kraken', status: 400 },
  { path: '/kraken/base', status: 403 },
  { path: '/metadata/events', status: 400 },
  { path: '/api/notifications', status: 403 },
  { path: '/pp', status: 403 },
  { path: '/tax_interview/new', status: 404 },
  { path: '/bug_reports/new', status: 301 },
  { path: '/contact', status: 301 },
  { path: '/subscriptions', status: 200 },
  { path: '/year', status: 404 },
  { path: '/year/2015', status: 200 },
  { path: '/search', status: 301 },
  { path: '/activate', status: 302 },
  { path: '/turbo', status: 301 },
  { path: '/inbox', status: 301 },
  { path: '/outbox', status: 301 },
  { path: '/messages/inbox', status: 302 },
  { path: '/messages/outbox', status: 302 },
  { path: '/message/list', status: 302 },
  { path: '/authorized_stream_keys', status: 404 },
  { path: '/authorized_stream_keys/123', status: 404 },
  { path: '/diresqrl/inbox', status: 302 },
  { path: '/diresqrl/outbox', status: 302 },
  { path: '/passport/user', status: 404 },
  { path: '/user/login', status: 301 },
  { path: '/user/signup', status: 301 },
  { path: '/login', status: 302 },
  { path: '/signup', status: 302 },
  { path: '/manager', status: 301 },
  { path: '/upload', status: 301 },
  { path: '/profile', status: 302 },
  { path: '/upload', status: 301 },
  { path: '/diresqrl/profile', status: 301 },
  { path: '/diresqrl/profile/followers', status: 301 },
  { path: '/diresqrl/profile/following', status: 301 },
  { path: '/diresqrl/dashboard', status: 302 },
  { path: '/diresqrl/dashboard/stats', status: 302 },
  { path: '/diresqrl/manager', status: 301 },
  { path: '/diresqrl/manager/clips', status: 200 },
  { path: '/diresqrl/settings', status: 302 },
  { path: '/itmejp/subscribe', status: 302 },
  { path: '/mailchimp/callback', status: 401 },
  { path: '/watch/anime', status: 404 },
  { path: '/about', status: 404 },
  { path: '/prime', status: 301 },
  { path: '/blog', status: 301 },
  { path: '/blog/123', status: 404 },
  { path: '/view', status: 404 },
  { path: '/view/123', status: 404 },
  { path: '/stream', status: 404 },
  { path: '/stream/123', status: 404 },
  { path: '/apple-app-site-association', status: 200 },
  { path: '/.well-known/apple-app-site-association', status: 200 },
  { path: '/event/twitchcon', status: 200 },
  { path: '/twitchcon', status: 302 }
].freeze
