# frozen_string_literal: true

require_relative 'bootstrap'
require 'minitest/autorun'

class PathRedirectCriteriaTest < Minitest::Test
  @@protocols = %i[http https].freeze
  @@twitch = @@protocols.map { |protocol| [protocol, Twitch::Web.create(protocol)] }.to_h

  def teardown
    sleep 0.5
  end

  BETA_PATHS_NO_REDIRECT.each do |data|
    define_method :"test_not_redirected_path_#{data[:path].gsub('/', '__')}" do
      res = @@twitch[:https].get(data[:path]) do |req|
        req.headers['Cookie'] = 'twilight_beta_force_redirect=1'
      end
      assert_equal data[:status], res.status, "Unexpected response of #{res.status} on #{data[:path]}, expected #{data[:status]}"
      refute_includes res.headers['location'], 'go.twitch.tv' if [301, 302].include?(data[:status])
    end
  end

  BETA_PATHS_REDIRECT.each do |path|
    define_method :"test_redirected_path_#{path.gsub('/', '__')}" do
      res = @@twitch[:https].get(path) do |req|
        req.headers['Cookie'] = 'twilight_beta_force_redirect=1'
      end
      assert_equal 302, res.status, "Unexpected response of #{res.status} on #{path}, expected 302"
      assert_includes res.headers['location'], 'https://go.twitch.tv'
    end
  end

  # def test_no_redirect_on_referer
  #   res = @@twitch[:https].get('/diresqrl') do |req|
  #     req.headers['referer'] = 'https://go.twitch.tv/diresqrl'
  #   end
  #   assert_equal 200, res.status, "Unexpected response of #{res.status} on /diresqrl, expected 200"
  #   # refute_includes res.headers['location'], 'https://go.twitch.tv' if [301, 302].include?(res.status)
  # end
end
