# frozen_string_literal: true

require_relative 'lib/route'

Twitch::Route.add '/', status: 200
Twitch::Route.add '/site_options.js', status: 200
Twitch::Route.add '/p/about', status: 200
Twitch::Route.add '/p/assets/uploads/wallstreet_deepfield_graph.jpg', status: 200
Twitch::Route.add '/p/legal/terms-of-service', status: 200
Twitch::Route.add '/p/terms-of-service', status: 302, location: '/p/terms-of-service/'
Twitch::Route.add '/pr/welcome', status: 302, location: 'https://twitch.amazon.com/prime/welcome?ref_=sm_w_ty_page_redirect'
Twitch::Route.add '/sw.js', status: 200
Twitch::Route.add '/broadcast', status: 200
Twitch::Route.add '/broadcast/stats', status: 200
Twitch::Route.add '/diresqrl/manager', status: 301, location: 'https://www.twitch.tv/diresqrl/manager/past_broadcasts'
Twitch::Route.add '/blusewilly_retry/profile', status: 301, location: 'https://www.twitch.tv/blusewilly_retry/videos/all'
Twitch::Route.add '/fantabobshow/profile', status: 301, location: 'https://www.twitch.tv/fantabobshow/videos/all'
Twitch::Route.add '/forcat3636/profile', status: 301, location: 'https://www.twitch.tv/forcat3636/videos/all'
Twitch::Route.add '/lirik/profile', status: 301, location: 'https://www.twitch.tv/lirik/videos/all'
Twitch::Route.add '/diresqrl/report_form', status: 200
Twitch::Route.add '/diresqrl/dashboard', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fdiresqrl%2Fdashboard'
Twitch::Route.add '/diresqrl/dashboard/action_log', status: 301, location: 'https://www.twitch.tv/diresqrl/dashboard/activity'
Twitch::Route.add '/diresqrl/dashboard/activity', status: 200
Twitch::Route.add '/diresqrl/dashboard/delay', status: 404
Twitch::Route.add '/diresqrl/dashboard/revenue', status: 200
Twitch::Route.add '/diresqrl/dashboard/stats', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fdiresqrl%2Fdashboard%2Fstats'
Twitch::Route.add '/broadcast/dashboard/streamkey', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fbroadcast%2Fdashboard%2Fstreamkey'
Twitch::Route.add '/broadcast/dashboard', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fbroadcast%2Fdashboard'
Twitch::Route.add '/broadcast/dashboards', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fbroadcast%2Fdashboards'
Twitch::Route.add '/broadcast/dashboards/diresqrl', status: 301, location: 'https://www.twitch.tv/diresqrl/dashboard'
Twitch::Route.add '/dashboard', status: 301, location: 'https://www.twitch.tv/broadcast/dashboard'
Twitch::Route.add '/profile', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fprofile'
Twitch::Route.add '/team/riotgames', status: 200
Twitch::Route.add '/team/riotgames/live_member_list', status: 200
Twitch::Route.add '/team/staff', status: 200
Twitch::Route.add '/team/staff/live_member_list', status: 200
Twitch::Route.add '/team/invitation', status: 404
Twitch::Route.add '/team/permission', status: 404
Twitch::Route.add '/chromecast/base64.js', status: 200
Twitch::Route.add '/chromecast/jquery.min.js', status: 200
Twitch::Route.add '/chromecast/media_receiver.html', status: 200
Twitch::Route.add '/chromecast/receiver.js', status: 200
Twitch::Route.add '/chromecast/spade.js', status: 200
Twitch::Route.add '/diresqrl/dashboard/subscription/merch-by-amazon', status: 200
Twitch::Route.add '/la2dreams/embed', status: 302, location: 'https://player.twitch.tv?channel=la2dreams'
Twitch::Route.add '/lolesportsla/embed', status: 302, location: 'https://player.twitch.tv?channel=lolesportsla'
Twitch::Route.add '/lvpes/embed', status: 302, location: 'https://player.twitch.tv?channel=lvpes'
Twitch::Route.add '/riotgamesru/embed', status: 302, location: 'https://player.twitch.tv?channel=riotgamesru'
Twitch::Route.add '/s4_league/embed', status: 302, location: 'https://player.twitch.tv?channel=s4_league'
Twitch::Route.add '/summonersinnlive/embed', status: 302, location: 'https://player.twitch.tv?channel=summonersinnlive'
Twitch::Route.add '/froggen/popout', status: 302, location: 'https://player.twitch.tv?channel=froggen'
Twitch::Route.add '/imaqtpie/popout', status: 302, location: 'https://player.twitch.tv?channel=imaqtpie'
Twitch::Route.add '/riotgames/popout', status: 302, location: 'https://player.twitch.tv?channel=riotgames'
Twitch::Route.add '/scarra/popout', status: 302, location: 'https://player.twitch.tv?channel=scarra'
Twitch::Route.add '/shiphtur/popout', status: 302, location: 'https://player.twitch.tv?channel=shiphtur'
Twitch::Route.add '/vgbootcamp/popout', status: 302, location: 'https://player.twitch.tv?channel=vgbootcamp'
Twitch::Route.add '/playbreakaway/streamplus', status: 200
Twitch::Route.add '/swflibs/TwitchPlayer.r1805fdf8cec14e5e658b83faaf6f985233b9432e.swf', status: 302, location: 'https://www-cdn.jtvnw.net/swflibs/TwitchPlayer.r94f0802bc518d3647d95c06804f6fcd16e81e44d.swf'
Twitch::Route.add '/swflibs/TwitchPlayer.r94bb0312865162bc8384ec5050df550dacd90e6f.swf', status: 302, location: 'https://www-cdn.jtvnw.net/swflibs/TwitchPlayer.r94f0802bc518d3647d95c06804f6fcd16e81e44d.swf'
Twitch::Route.add '/swflibs/TwitchPlayer.r94f0802bc518d3647d95c06804f6fcd16e81e44d.swf', status: 200
Twitch::Route.add '/swflibs/TwitchPlayer.rec8c4ca12340437be4d114de260aacbc24bdb830.swf', status: 302, location: 'https://www-cdn.jtvnw.net/swflibs/TwitchPlayer.r94f0802bc518d3647d95c06804f6fcd16e81e44d.swf'
Twitch::Route.add '/swflibs/TwitchPlayer.rfc07d37fc4eed1d17243b452dd3441665496e1e0.swf', status: 302, location: 'https://www-cdn.jtvnw.net/swflibs/TwitchPlayer.r94f0802bc518d3647d95c06804f6fcd16e81e44d.swf'
Twitch::Route.add '/swflibs/TwitchPlayer.swf', status: 302, location: 'https://www-cdn.jtvnw.net/swflibs/TwitchPlayer.r94f0802bc518d3647d95c06804f6fcd16e81e44d.swf'
Twitch::Route.add '/widgets/archive_embed_player.swf', status: 302, location: 'http://www.twitch.tv/swflibs/TwitchPlayer.swf?old=1'
Twitch::Route.add '/widgets/archive_facebook_embed_player.swf', status: 302, location: 'http://www.twitch.tv/swflibs/TwitchPlayer.swf?old=1'
Twitch::Route.add '/widgets/clip_embed_player.swf', status: 302, location: 'http://www.twitch.tv/swflibs/TwitchPlayer.swf?old=1'
Twitch::Route.add '/widgets/live_embed_player.r245719c13c44924ecaa2ddd8a106c88b7583fa76.swf', status: 406
Twitch::Route.add '/widgets/live_embed_player.swf', status: 302, location: 'http://www.twitch.tv/swflibs/TwitchPlayer.swf?old=1'
Twitch::Route.add '/widgets/live_facebook_embed_player.swf', status: 302, location: 'http://www.twitch.tv/swflibs/TwitchPlayer.swf?old=1'
Twitch::Route.add '/buks/v/3753822', status: 301, location: 'https://www.twitch.tv/videos/3753822'
Twitch::Route.add '/egltv/v/3750607', status: 301, location: 'https://www.twitch.tv/videos/3750607'
Twitch::Route.add '/hcjustin/v/64596746', status: 301, location: 'https://www.twitch.tv/videos/64596746'
Twitch::Route.add '/logan4prezz/v/5964253', status: 301, location: 'https://www.twitch.tv/videos/5964253'
Twitch::Route.add '/pielord1177/v/180517428', status: 301, location: 'https://www.twitch.tv/videos/180517428'
Twitch::Route.add '/timmac/v/3778450', status: 301, location: 'https://www.twitch.tv/videos/3778450'
Twitch::Route.add '/hrkchannel/videos/all', status: 200
Twitch::Route.add '/lirik/videos/all', status: 200
Twitch::Route.add '/reckful/videos/all', status: 200
Twitch::Route.add '/riotgames/videos/all', status: 200
Twitch::Route.add '/sp4zie/videos/all', status: 200
Twitch::Route.add '/strimhata/videos/all', status: 200
Twitch::Route.add '/collections/cSDu1TMk1hQOLA', status: 200
Twitch::Route.add '/collections/F7SKTkBOrBTZZQ', status: 200
Twitch::Route.add '/collections/FCJIcx5C5BQ0Ag', status: 200
Twitch::Route.add '/collections/jZafP4Nt3xT8Cw', status: 200
Twitch::Route.add '/collections/p8vZLZy06RRflw', status: 200
Twitch::Route.add '/collections/QboGeM5wrBRESA', status: 200
Twitch::Route.add '/diresqrl/dashboard/video-stats', status: 200
Twitch::Route.add '/upload', status: 301, location: 'https://www.twitch.tv/manager/upload'
Twitch::Route.add '/diresqrl/manager/past_broadcasts', status: 200
Twitch::Route.add '/diresqrl/manager/uploads', status: 200
Twitch::Route.add '/manager/past_broadcasts', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fmanager%2Fpast_broadcasts'
Twitch::Route.add '/manager/upload', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fmanager%2Fupload'
Twitch::Route.add '/manager/uploads', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fmanager%2Fuploads'
Twitch::Route.add '/videos/180336153', status: 200
Twitch::Route.add '/videos/180343443', status: 200
Twitch::Route.add '/videos/180430384', status: 200
Twitch::Route.add '/videos/180612409', status: 200
Twitch::Route.add '/videos/180616217', status: 200
Twitch::Route.add '/streams/26432425024/channel/54825274', status: 200
Twitch::Route.add '/streams/26433734560/channel/64215353', status: 200
Twitch::Route.add '/streams/26436054752/channel/38340508', status: 200
Twitch::Route.add '/streams/26436612000/channel/161149071', status: 200
Twitch::Route.add '/streams/26437459792/channel/37323664', status: 200
Twitch::Route.add '/streams/26438327248/channel/156567621', status: 200
Twitch::Route.add '/alanzoka/collections', status: 200
Twitch::Route.add '/bayriffer/collections', status: 200
Twitch::Route.add '/hrkchannel/collections', status: 200
Twitch::Route.add '/khobsanam/collections', status: 200
Twitch::Route.add '/riotgames/collections', status: 200
Twitch::Route.add '/rubsarb/collections', status: 200
Twitch::Route.add '/status.json', status: 200
Twitch::Route.add '/ember_deps.js', status: 200
Twitch::Route.add '/favicon.ico', status: 200
Twitch::Route.add '/live', status: 301, location: 'https://www.twitch.tv'
Twitch::Route.add '/settings', status: 200
Twitch::Route.add '/settings/channel', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fsettings%2Fchannel'
Twitch::Route.add '/settings/connections', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fsettings%2Fconnections'
Twitch::Route.add '/settings/notifications', status: 200
Twitch::Route.add '/settings/prime', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fsettings%2Fprime'
Twitch::Route.add '/settings/profile', status: 200
Twitch::Route.add '/settings/security', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fsettings%2Fsecurity'
Twitch::Route.add '/settings/subscriptions', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fsettings%2Fsubscriptions'
Twitch::Route.add '/settings/turbo', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fsettings%2Fturbo'
Twitch::Route.add '/activate', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Factivate'
Twitch::Route.add '/apple-touch-icon.png', status: 200
Twitch::Route.add '/cohhcarnage/mobile', status: 302, location: 'https://m.twitch.tv/cohhcarnage'
Twitch::Route.add '/day9tv/mobile', status: 302, location: 'https://m.twitch.tv/day9tv'
Twitch::Route.add '/fxckzz199/mobile', status: 302, location: 'https://m.twitch.tv/fxckzz199'
Twitch::Route.add '/killingteam/mobile', status: 302, location: 'https://m.twitch.tv/killingteam'
Twitch::Route.add '/android', status: 301, location: 'https://play.google.com/store/apps/details?id=tv.twitch.android.viewer'
Twitch::Route.add '/.well-known/apple-app-site-association', status: 200
Twitch::Route.add '/apple-app-site-association', status: 200
Twitch::Route.add '/experiments.json', status: 200
Twitch::Route.add '/running', status: 200
Twitch::Route.add '/diresqrl/dashboard/subscription/game-commerce', status: 200
Twitch::Route.add '/inventory', status: 200
Twitch::Route.add '/directory/game/Cuphead/details', status: 200
Twitch::Route.add '/diresqrl/dashboard/subscription/ads', status: 200
Twitch::Route.add '/diresqrl/dashboard/subscription/video', status: 200
Twitch::Route.add '/bits/config.json', status: 404
Twitch::Route.add '/blizzheroes/esports/hgc-2017', status: 200
Twitch::Route.add '/evenmatchupgaming/subscribe', status: 302, location: 'https://www.twitch.tv/products/evenmatchupgaming/ticket'
Twitch::Route.add '/meleeeveryday/subscribe', status: 302, location: 'https://www.twitch.tv/products/meleeeveryday/ticket'
Twitch::Route.add '/pink_sparkles/subscribe', status: 302, location: 'https://www.twitch.tv/products/pink_sparkles/ticket'
Twitch::Route.add '/simpleflips/subscribe', status: 302, location: 'https://www.twitch.tv/products/simpleflips/ticket'
Twitch::Route.add '/tyrannasauruslex/subscribe', status: 302, location: 'https://www.twitch.tv/products/tyrannasauruslex/ticket'
Twitch::Route.add '/vgbootcamp/subscribe', status: 302, location: 'https://www.twitch.tv/products/vgbootcamp/ticket'
Twitch::Route.add '/diresqrl/dashboard/subscription', status: 200
Twitch::Route.add '/diresqrl/dashboard/subscription/badges', status: 200
Twitch::Route.add '/diresqrl/dashboard/subscription/chat', status: 200
Twitch::Route.add '/diresqrl/dashboard/subscription/chatperks', status: 200
Twitch::Route.add '/diresqrl/dashboard/subscription/creative', status: 200
Twitch::Route.add '/diresqrl/dashboard/subscription/ticket', status: 200
Twitch::Route.add '/diresqrl/dashboard/subscription/view-terms', status: 200
Twitch::Route.add '/diresqrl/dashboard/subscription/cheer', status: 200
Twitch::Route.add '/diresqrl/dashboard/subscription/cheerbadges', status: 200
Twitch::Route.add '/diresqrl/dashboard/subscription/cheermotes', status: 200
Twitch::Route.add '/products/geekandsundry/ticket', status: 200
Twitch::Route.add '/products/pink_sparkles/ticket', status: 200
Twitch::Route.add '/products/ratsmah/ticket', status: 200
Twitch::Route.add '/products/turbo', status: 200
Twitch::Route.add '/products/turbo/ticket', status: 200
Twitch::Route.add '/products/bits/ad', status: 200
Twitch::Route.add '/subscriptions', status: 200
Twitch::Route.add '/turbo', status: 301, location: 'https://www.twitch.tv/products/turbo'
Twitch::Route.add '/directory/game/Paladins/details', status: 200
Twitch::Route.add '/directory/game/Smite/details', status: 200
Twitch::Route.add '/directory/game/Warframe/details', status: 200
Twitch::Route.add '/store/merch', status: 200
Twitch::Route.add '/store', status: 200
Twitch::Route.add '/diresqrl/dashboard/subscription/payout-onboarding', status: 200
Twitch::Route.add '/diresqrl/dashboard/subscription/payouts', status: 200
Twitch::Route.add '/store/games', status: 200
Twitch::Route.add '/store/games/assets/fonts/korolev-medium.otf', status: 200
Twitch::Route.add '/store/games/assets/images/bg-pattern.png', status: 200
Twitch::Route.add '/store/games/assets/images/oval.png', status: 200
Twitch::Route.add '/store/games/assets/images/platforms-twitch-desktop-app.jpg', status: 200
Twitch::Route.add '/store/games/assets/main.css', status: 200
Twitch::Route.add '/diresqrl/settings', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fdiresqrl%2Fsettings'
Twitch::Route.add '/diresqrl/settings/streamkey', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fdiresqrl%2Fsettings%2Fstreamkey'
Twitch::Route.add '/diresqrl/manager/clips', status: 200
Twitch::Route.add '/r/l/email_click/eyJjb250ZW50IjoiMjAxNjAzMTVjcmVhdGl2ZSIsIm1lZGl1bSI6InR3aXRjaGJsb2ciLCJwYXRoIjoiL2Zvb2QifQ==/c3cc57a596307e440cef06518aba58dd71da5968/food', status: 302, location: 'https://www.twitch.tv/'
Twitch::Route.add '/r/l/email_click/eyJjb250ZW50IjoiMjAxNjAzMTVjcmVhdGl2ZSIsIm1lZGl1bSI6InR3aXRjaGJsb2ciLCJwYXRoIjoiL3NjZW5lb2ZhY3Rpb25tdXNpYyJ9/9356784c99eb74bbf2f9574cd3aa29f29d25b5d0/sceneofactionmusic', status: 302, location: 'https://www.twitch.tv/'
Twitch::Route.add '/r/l/related_channel_click/eyJyZWZlcnJlciI6Im5pcGdhbWluZ3R2Iiwic291cmNlIjoiZ2FtZSJ9/3f0168e8a760952a50a44664975cd40d8c8841b8/kqly', status: 302, location: 'https://www.twitch.tv/'
Twitch::Route.add '/r/l/related_channel_click/eyJyZWZlcnJlciI6ImJha2VybGl2ZSIsInNvdXJjZSI6ImdhbWUifQ==/630b514d7258d3ec61123ba91af8aa9307ff6db2/eillax', status: 302, location: 'https://www.twitch.tv/'
Twitch::Route.add '/r/l/related_channel_click/eyJyZWZlcnJlciI6InRha2V0diIsInNvdXJjZSI6ImdhbWUifQ==/2054a320a898ac146336c0f9ed0b6a204fe3f596/welmu1', status: 302, location: 'https://www.twitch.tv/'
Twitch::Route.add '/r/l/related_channel_click/eyJzb3VyY2UiOiJnYW1lIiwicmVmZXJyZXIiOiJlc2xiZW5lbHV4In0=/98ba6a2822c8c21ad0ae763dda41c6da3a37ce54/kungentv', status: 302, location: 'https://www.twitch.tv/'
Twitch::Route.add '/aga191919/clips', status: 200
Twitch::Route.add '/drdisrespectlive/clips', status: 200
Twitch::Route.add '/mitchjones/clips', status: 200
Twitch::Route.add '/reckful/clips', status: 200
Twitch::Route.add '/sodapoppin/clips', status: 200
Twitch::Route.add '/stpeach/clips', status: 200
Twitch::Route.add '/directory/game/Counter-Strike%3A%20Global%20Offensive/clips', status: 200
Twitch::Route.add '/directory/game/Dota%202/clips', status: 200
Twitch::Route.add '/directory/game/Hearthstone/clips', status: 200
Twitch::Route.add '/directory/game/IRL/clips', status: 200
Twitch::Route.add "/directory/game/PLAYERUNKNOWN'S%20BATTLEGROUNDS/clips", status: 200
Twitch::Route.add '/directory/game/League%20of%20Legends/clips', status: 200
Twitch::Route.add '/directory/game/Dota%202/videos/all', status: 200
Twitch::Route.add '/directory/game/Dragon%20Ball%20Online/videos/all', status: 200
Twitch::Route.add '/directory/game/League%20of%20Legends/videos/all', status: 200
Twitch::Route.add '/directory/game/S.K.I.L.L.:%20Special%20Force%202/videos/all', status: 200
Twitch::Route.add '/directory/game/Star%20Wars:%20Battlefront%20II/videos/all', status: 200
Twitch::Route.add '/directory/videos', status: 200
Twitch::Route.add '/directory/videos/all', status: 200
Twitch::Route.add '/directory/videos/highlights', status: 200
Twitch::Route.add '/directory/videos/month', status: 200
Twitch::Route.add '/directory/videos/past-broadcasts', status: 200
Twitch::Route.add '/directory/videos/week', status: 200
Twitch::Route.add '/manager/clips', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fmanager%2Fclips'
Twitch::Route.add '/adamkoebel/events', status: 200
Twitch::Route.add '/riotgames/events', status: 200
Twitch::Route.add '/time_of_chaos/events', status: 200
Twitch::Route.add '/twitch/events', status: 200
Twitch::Route.add '/vgbootcamp/events', status: 200
Twitch::Route.add '/wearethevr/events', status: 200
Twitch::Route.add '/faegwent/followers', status: 200
Twitch::Route.add '/riotgames/followers', status: 200
Twitch::Route.add '/shroud/followers', status: 200
Twitch::Route.add '/summit1g/followers', status: 200
Twitch::Route.add '/xliverobot/followers', status: 200
Twitch::Route.add '/blackufa_twitch/following', status: 200
Twitch::Route.add '/overwatchcontenders/following', status: 200
Twitch::Route.add '/riotgames/following', status: 200
Twitch::Route.add '/shroud/following', status: 200
Twitch::Route.add '/silvername/following', status: 200
Twitch::Route.add '/strimhata/following', status: 200
Twitch::Route.add '/cinnamontoastken/p/d9957fb9-03ea-4a05-9056-3a2ee6641f20', status: 200
Twitch::Route.add '/jackpattillo/p/b2f0c018-7ca9-4e29-b5ca-48f0b5acbf69', status: 200
Twitch::Route.add '/jimlee/p/5cd0fc3d-d5b3-41f6-aec6-8db3aca0fa41', status: 200
Twitch::Route.add '/diresqrl/dashboard/events', status: 200
Twitch::Route.add '/directory', status: 200
Twitch::Route.add '/directory/creative', status: 200
Twitch::Route.add '/directory/discover', status: 200
Twitch::Route.add '/directory/following', status: 200
Twitch::Route.add '/directory/following/communities', status: 200
Twitch::Route.add '/directory/following/games', status: 200
Twitch::Route.add '/directory/following/hosts', status: 200
Twitch::Route.add '/directory/following/live', status: 200
Twitch::Route.add '/directory/game/Dota%202', status: 200
Twitch::Route.add '/directory/game/Dota%202/ru', status: 200
Twitch::Route.add '/directory/game/Hearthstone', status: 200
Twitch::Route.add '/directory/game/IRL', status: 200
Twitch::Route.add '/directory/game/League%20of%20Legends', status: 200
Twitch::Route.add '/directory/game/League%20of%20Legends/es', status: 200
Twitch::Route.add '/directory/game/League%20of%20Legends/pt', status: 200
Twitch::Route.add '/directory/game/League%20of%20Legends/tr', status: 200
Twitch::Route.add '/directory/game/League%20of%20Legends/zh', status: 200
Twitch::Route.add '/directory/game/Overwatch', status: 200
Twitch::Route.add "/directory/game/PLAYERUNKNOWN'S%20BATTLEGROUNDS", status: 200
Twitch::Route.add '/directory/game/World%20of%20Tanks/ru', status: 200
Twitch::Route.add '/directory/game/Dota%202/live', status: 200
Twitch::Route.add '/directory/game/RuneScape/live', status: 200
Twitch::Route.add '/directory/game/World%20of%20Warcraft:%20Mists%20of%20Pandaria/live', status: 200
Twitch::Route.add '/directory/all', status: 200
Twitch::Route.add '/directory/all/fr', status: 200
Twitch::Route.add '/directory/all/ru', status: 200
Twitch::Route.add '/directory/random', status: 301, location: 'https://www.twitch.tv/directory'
Twitch::Route.add '/event/pax/live_member_list', status: 200
Twitch::Route.add '/search', status: 301, location: 'https://www.twitch.tv/'
Twitch::Route.add '/freesports222/chat', status: 200
Twitch::Route.add '/gentichatnfl/chat', status: 200
Twitch::Route.add '/killfrenz/chat', status: 200
Twitch::Route.add '/shadbasemurdertv/chat', status: 200
Twitch::Route.add '/twitchpresents/chat', status: 200
Twitch::Route.add '/vgbootcamp/chat', status: 200
Twitch::Route.add '/diresqrl', status: 200
Twitch::Route.add '/diresqrl/outbox', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fdiresqrl%2Foutbox'
Twitch::Route.add '/chat/embed?channel=itmejp', status: 302, location: 'https://www.twitch.tv/embed/itmejp/chat'
Twitch::Route.add '/chat/embed?channel=lirik', status: 302, location: 'https://www.twitch.tv/embed/lirik/chat'
Twitch::Route.add '/chat/embed?channel=twitchpresents', status: 302, location: 'https://www.twitch.tv/embed/twitchpresents/chat'
Twitch::Route.add '/communities/failyv', status: 200
Twitch::Route.add '/communities/gamedevelopment', status: 200
Twitch::Route.add '/communities/music', status: 200
Twitch::Route.add '/communities/programming', status: 200
Twitch::Route.add '/communities/speedrunning', status: 200
Twitch::Route.add '/communities', status: 301, location: 'https://www.twitch.tv/directory/communities'
Twitch::Route.add '/diresqrl/dashboard/moderation', status: 200
Twitch::Route.add '/directory/communities', status: 200
Twitch::Route.add '/dmca/login', status: 200
Twitch::Route.add '/dmca/sent', status: 302, location: 'https://www.twitch.tv/dmca/login'
Twitch::Route.add '/dmca/takedown', status: 302, location: 'https://www.twitch.tv/dmca/login'
Twitch::Route.add '/following', status: 301, location: 'https://www.twitch.tv/directory/following'
Twitch::Route.add '/friends', status: 200
Twitch::Route.add '/friends/requests', status: 200
Twitch::Route.add '/bug_reports/new', status: 302, location: 'https://help.twitch.tv/customer/portal/emails/new'
Twitch::Route.add '/contact', status: 302, location: 'https://help.twitch.tv/customer/portal/emails/new'
Twitch::Route.add '/help', status: 302, location: 'https://help.twitch.tv/customer/portal/emails/new'
Twitch::Route.add '/desk/multipass', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fdesk%2Fmultipass'
Twitch::Route.add '/inbox', status: 301, location: 'https://www.twitch.tv/messages/inbox'
Twitch::Route.add '/tmilibs/JSSocket.r87d5ce36f728d05d6dd7726f53841fa72b521499.swf', status: 200
Twitch::Route.add '/tmilibs/JSSocket.swf', status: 302, location: 'JSSocket.r87d5ce36f728d05d6dd7726f53841fa72b521499.swf'
Twitch::Route.add '/message/compose', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fmessage%2Fcompose'
Twitch::Route.add '/message/list', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fmessage%2Flist'
Twitch::Route.add '/messages/inbox', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fmessages%2Finbox'
Twitch::Route.add '/messages/other', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fmessages%2Fother'
Twitch::Route.add '/messages/outbox', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fmessages%2Foutbox'
Twitch::Route.add '/outbox', status: 301, location: 'https://www.twitch.tv/messages/outbox'
Twitch::Route.add '/tmilibs/tmi-v3.js', status: 302, location: 'tmi-v3.ra99a30167cc0b7ea117bfaa34870530558fdba84.js'
Twitch::Route.add '/tmilibs/tmi-v3.ra99a30167cc0b7ea117bfaa34870530558fdba84.js', status: 200
Twitch::Route.add '/tmilibs/tmi-v3.radc7182b2bb2a7e67d54e64a5312048ee1f9ebda.js', status: 302, location: 'tmi-v3.ra99a30167cc0b7ea117bfaa34870530558fdba84.js'
Twitch::Route.add '/robots.txt', status: 200
Twitch::Route.add '/assets/application-9d1e12c7e657f718ede7137696fab963.js', status: 200
Twitch::Route.add '/assets/bootstrap_ember_component-670f42d6113ab407a90847b290a5f45a.js', status: 200
Twitch::Route.add '/assets/emberhelper-4674cf177d55f8a9cc492ee96ef3cdf0.js', status: 200
Twitch::Route.add '/assets/mobileRedirect-5d8df2504465e46617d2fd12d170bd2a.js', status: 200
Twitch::Route.add '/assets/pages/settings/index-323e23f21130513d51c11e87bb398bea.js', status: 200
Twitch::Route.add '/images/xarth/pages/error/error_castle.png', status: 200
Twitch::Route.add '/year/2014', status: 200
Twitch::Route.add '/year/2015', status: 200
Twitch::Route.add '/year/2016/', status: 200
Twitch::Route.add '/year/2016/assets/css/styles.min.css', status: 200
Twitch::Route.add '/year/2016/assets/favicon/favicon.ico', status: 200
Twitch::Route.add '/year/2016/assets/js/app.min.js', status: 200
Twitch::Route.add '/year/2016/assets/js/vendor/clipboard.min.js', status: 200
Twitch::Route.add '/year/2016/assets/js/vendor/jquery.keydrown.min.js', status: 200
Twitch::Route.add '/kraken/oauth2/authorization/120174', status: 400
Twitch::Route.add '/kraken/oauth2/authorization/122050', status: 400
Twitch::Route.add '/kraken/oauth2/authorization/17693', status: 400
Twitch::Route.add '/kraken/oauth2/authorization/34523', status: 400
Twitch::Route.add '/kraken/oauth2/authorization/71962', status: 400
Twitch::Route.add '/kraken/oauth2/authorization/80183', status: 400
Twitch::Route.add '/diresqrl/dashboard/extensions', status: 200
Twitch::Route.add '/diresqrl/dashboard/permissions', status: 200
Twitch::Route.add '/diresqrl/dashboard/settings', status: 200
Twitch::Route.add '/ext/24u62kim5mn0slhwigdt7v4ybkwef5-1.0.3', status: 200
Twitch::Route.add '/ext/4ntuott0zqw008atk0wy60phfa8jyf-0.0.9', status: 200
Twitch::Route.add '/ext/h7683cdyci11yov0tlac9f6lkvgtzi-0.0.5', status: 200
Twitch::Route.add '/ext/wi08ebtatdc7oj83wtl9uxwz807l8b', status: 200
Twitch::Route.add '/ext/zfh2irvx2jb4s60f02jq0ajm8vwgka', status: 200
Twitch::Route.add '/ext/zfh2irvx2jb4s60f02jq0ajm8vwgka-1.0.12', status: 200
Twitch::Route.add '/login', status: 302, location: 'https://passport.twitch.tv/sessions/new'
Twitch::Route.add '/logout', status: 301, location: 'https://www.twitch.tv/'
Twitch::Route.add '/logins/new', status: 301, location: 'https://passport.twitch.tv/logins/new'
Twitch::Route.add '/passport/callback', status: 404
Twitch::Route.add '/signup', status: 302, location: 'https://passport.twitch.tv/signup/new'
Twitch::Route.add '/yt/pokimane', status: 200
Twitch::Route.add '/yt/riotgames', status: 200
Twitch::Route.add '/yt/summit1g', status: 200
Twitch::Route.add '/yt/summonersinnlive', status: 200
Twitch::Route.add '/yt/terracid', status: 200
Twitch::Route.add '/yt/totalbiscuit', status: 200
Twitch::Route.add '/event/pax', status: 200
Twitch::Route.add '/event/twitchcon', status: 200
Twitch::Route.add '/event/twitchcon/live_member_list', status: 200
Twitch::Route.add '/events/112116', status: 200
Twitch::Route.add '/events/123107', status: 200
Twitch::Route.add '/events/123120', status: 200
Twitch::Route.add '/events/123123', status: 200
Twitch::Route.add '/events/123124', status: 200
Twitch::Route.add '/events/81117', status: 200
Twitch::Route.add '/p/watch/anime', status: 200
Twitch::Route.add '/watch/anime', status: 404
Twitch::Route.add '/lirik', status: 200
Twitch::Route.add '/reckful', status: 200
Twitch::Route.add '/riotgames', status: 200
Twitch::Route.add '/rocketleague', status: 200
Twitch::Route.add '/shroud', status: 200
Twitch::Route.add '/summit1g', status: 200
Twitch::Route.add '/partner/ingest', status: 302, location: 'https://www.twitch.tv/login?redirect_on_login=%2Fpartner%2Fingest'
Twitch::Route.add '/partner/signup', status: 200
Twitch::Route.add '/p/partners', status: 200
