# frozen_string_literal: true

require_relative 'bootstrap'
require 'minitest/autorun'
require 'pry'

class TwilightTest < Minitest::Test
  def twitch
    @twitch ||= Faraday.new("https://www.twitch.tv") do |conn|
      conn.use :cookie_jar
      conn.adapter Faraday.default_adapter
    end
  end

  def teardown
    sleep 0.25
  end

  Twitch::Route.list.each do |route|
    define_method :"test_path_#{route[:path].tr('/', '_')}" do
      res = twitch.get(route[:path])

      # verify that we are hitting our Fastly config
      refute_nil res.headers['x-served-by'], 'Expected X-Served-By header to be present'
      assert_match /^cache-[a-z]{3}[0-9]{4}-[A-Z]{3}/, res.headers['x-served-by']

      # TODO: verify expected backend
      refute_nil res.headers['x-backend'], 'Expected X-Backend header to be present'
      # assert_match /#{route[:backend]}/, res.headers['x-backend']


      # verify that we have our expected http status
      assert_equal route[:status], res.status, "Unexpected response of #{res.status} on #{route[:path]}, expected #{route[:status]}"

      # verify that we have proper location header for 3xx
      assert_includes res.headers['location'], route[:location] unless route[:location].nil?
    end
  end
end
