﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Curse.Cerium;
using Curse.ClientService.Models;
using ServiceStack.Text;

namespace Curse.BugReportingService.RestClient
{
    public class BugReportingServiceRestClient : CeriumRestClient<BugReportingServiceRestClient>
    {
        public static readonly BugReportingServiceRestClient Instance = new BugReportingServiceRestClient();

        static BugReportingServiceRestClient()
        {
            Configuration.TimeoutSeconds = 10;
            Configuration.UserAgent = "Curse/1.0";
        }

        public static void Initialize(string serviceBaseUrl)
        {
            ServiceBaseUrl = serviceBaseUrl;

        }

        protected BugReportingServiceRestClient()
        {

        }

        public BugReportResponse SubmitBugReport(BugReport bugReport)
        {
            // Preserialize it
            var serializer = new JsonSerializer<BugReport>();
            var value = serializer.SerializeToString(bugReport);
            return Post<BugReportRequest, BugReportResponse>(new BugReportRequest {BugReportJson = value }, "SubmitBugReportJson");
        }
    }
}
