﻿
# User Reporting Service Rest Client

The Curse Reporting Service Rest Client is designed to provide bug reporting, usage reporting and user abuse reporting endpoints.

## Cerium Configuration

The following explains how to configure Cerium. While not required, the following two configuration options may be necessary:

**SSL Ceritifcate Validation**

Depending on the environment you are accessing (dev, staging, production), you may or may not be using self-signed certs. If this is the case you must disable certification validation. 

```
CeriumConfiguration.DisableCertificateValidation();
```

**Service Stack**

Cerium depends on the Service Stack JSON serializer. The free version supports up to 20 different classes per app-domain. If you app uses more than this, you will need to supply a license key. 

```
CeriumConfiguration.ServiceStackLicenseKey = @"YOUR-LICENSE-KEY";
```
&nbsp;
## User Reporting Service Rest Client Configuration

Before the User Reporting Service Rest Client can be used, it must first be initialized. Base configuration for the client is minimal. 

```
UserReportingServiceRestClient.Initialize(serviceUrl);
```


- **Service Url** (String): The web service is available in staging and production. You must supply the url as a string (https is required).

 &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Staging: https://clientservice-v6.curse.stg/ClientUserReportingService.svc/json/

 &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Production: https://clientservice-v6-beta.curse.com/ClientUserReportingService.svc/json/

&nbsp;
## Advanced Configuration

In addition to required configuration exposed through the Initialize method, advanced configuration options are exposed through the Configuration property of the Login Service Rest Client singleton. Below are the default configuration options, that can be changed at runtime.

```
UserReportingServiceRestClient.Instance.Configuration.DisableProxyDetection = true;
UserReportingServiceRestClient.Instance.Configuration.UserAgent = "Curse/1.0";
UserReportingServiceRestClient.Instance.Configuration.ContentType = "application/json";
UserReportingServiceRestClient.Instance.Configuration.TimeoutSeconds = 10;
```

- **DisableProxyDetection** (Boolean): When True, the internal .NET web client will not attempt to detect http proxy information. This is used to speed up the client.

- **UserAgent** (String): Supplied in the request header with each request so that the server can identify the client type.

- **ContentType** (String): Supplied in the request header with each request so that the server knows the content type to expect in the request and to supply in the response. Setting this to anything other than application/json is currently unsupported.

- **TimeoutSeconds** (Int32): How long the client should wait to receive a response from the service. This should be tuned based on the connection quality of the client.

&nbsp;
## Methods
The  User Reporting Service Rest Client is a singleton implementation that provides one line access to every web service method available.

&nbsp;
#### ReportUserAbuse

The only method currently implemented is ReportUserAbuse.

```
var resp = UserReportingServiceRestClient.Instance.ReportUserAbuse(report);
```

**Parameters**

- **report** (UserAbuseReportRequest): A model containing the fields required to report a user.
   

**Return Value**
The ReportUserAbuse method returns a UserAbuseReportResponse, which currently consists of one property, Status. 

Status is an AuthenticationStatus enum which has the following valus:

- Error,
- Successful,
- Invalid,
- NotFound,

&nbsp;

## Sample

Here's a simple example that demonstrates a fully working implementation of the client. Please note that for this example no exception handling is in place for readability. In an actual client **all** web service calls should be wrapped in a try catch pattern, with proper logging and error handling.

```
// Initialize Cerium with the service stack license
CeriumConfiguration.ServiceStackLicenseKey = @"YOUR-LICENSE-KEY";

// Initialize the rest client with the url, user id, and auth token
UserReportingServiceRestClient.Initialize("https://clientservice-v6.curse.stg/ClientUserReportingService.svc/json/");

// Set the auth token that exists for the current user (from the login service)
UserReportingServiceRestClient.SetAuthToken(userID, token);

// Create the report request
var report = new UserAbuseReportRequest { Reason = UserAbuseReportReason.Harassment, ReportDescription = "This user was very mean to me.", ReportedUserID = 128, ReportingUserPlatform = ClientPlatform.iPhone };

// Try to register to get a notification server session
var resp = UserReportingServiceRestClient.Instance.ReportUserAbuse(report);

// Check our response status	
if(resp.Status != UserAbuseReportRequestStatus.Successful)
{
	Logger.Warn("Failed to login!", resp);
	return;
}


```