﻿using System;
using System.Collections.Specialized;
using Curse.Cerium;
using Curse.ClientService.Models;
using Curse.CloudServices.Models;
using Newtonsoft.Json;

namespace Curse.ReportingService.RestClient
{

    public class ReportingServiceRestClient : CeriumRestClient<ReportingServiceRestClient>
    {
        public static readonly ReportingServiceRestClient Instance = new ReportingServiceRestClient();
        private static string _authTokenJson;

        static ReportingServiceRestClient()
        {
            Configuration.TimeoutSeconds = 10;
            Configuration.UserAgent = "Curse/1.0";
        }

        public static void Initialize(string serviceBaseUrl)
        {
            if (!serviceBaseUrl.EndsWith("/"))
            {
                serviceBaseUrl = serviceBaseUrl + "/";
            }

            ServiceBaseUrl = serviceBaseUrl;

        }

        protected ReportingServiceRestClient()
        {

        }

        public static void SetAuthToken(int userID, string token)
        {
            var authToken = new AuthenticationToken { UserID = userID, Token = token };            
            _authTokenJson = JsonConvert.SerializeObject(authToken);
        }

        protected override NameValueCollection GetCustomHeaders()
        {
            if (string.IsNullOrEmpty(_authTokenJson))
            {
                return new NameValueCollection() { };                
            }
            else
            {
                return new NameValueCollection() { { AuthenticationToken.HeaderName, _authTokenJson } };
            }
           
        }

        public bool SaveUsageProfile(UsageProfile usageProfile)
        {
            if (string.IsNullOrEmpty(_authTokenJson))
            {
                throw new Exception("You must be logged in to submit a usage profile!");
            }

            return Post<UsageProfile, bool>(usageProfile, "SaveUsageProfile");
        } 

        public BugReportResponse SubmitBugReport(BugReport bugReport)
        {            
            // Preserialize it            
            var value = JsonConvert.SerializeObject(bugReport);
            return Post<BugReportRequest, BugReportResponse>(new BugReportRequest { BugReportJson = value }, "SubmitBugReportJson");
        }
    }
}
