﻿using System;
using System.Collections.Specialized;
using Curse.Cerium;
using Curse.ClientService.Models;
using Curse.CloudServices.Models;
using Newtonsoft.Json;

namespace Curse.ReportingService.RestClient
{

    public class UserReportingServiceRestClient : CeriumRestClient<UserReportingServiceRestClient>
    {
        public static readonly UserReportingServiceRestClient Instance = new UserReportingServiceRestClient();
        private static string _authTokenJson;

        static UserReportingServiceRestClient()
        {
            Configuration.TimeoutSeconds = 10;
            Configuration.UserAgent = "Curse/1.0";
        }

        public static void Initialize(string serviceBaseUrl)
        {
            if (!serviceBaseUrl.EndsWith("/"))
            {
                serviceBaseUrl = serviceBaseUrl + "/";
            }

            ServiceBaseUrl = serviceBaseUrl;

        }

        protected UserReportingServiceRestClient()
        {

        }

        public static void SetAuthToken(int userID, string token)
        {
            var authToken = new AuthenticationToken { UserID = userID, Token = token };            
            _authTokenJson = JsonConvert.SerializeObject(authToken);
        }

        protected override NameValueCollection GetCustomHeaders()
        {
            if (string.IsNullOrEmpty(_authTokenJson))
            {
                return new NameValueCollection() { };                
            }
            else
            {
                return new NameValueCollection() { { AuthenticationToken.HeaderName, _authTokenJson } };
            }
           
        }

        public UserAbuseReportResponse ReportUserAbuse(UserAbuseReportRequest report)
        {
            if (string.IsNullOrEmpty(_authTokenJson))
            {
                throw new Exception("You must be logged in to submit a usage profile!");
            }

            return Post<UserAbuseReportRequest, UserAbuseReportResponse>(report, "ReportUserAbuse");
        }         
    }
}
