﻿using System;
using System.Diagnostics;
using Curse.Logging;

namespace Curse.Cerium
{
    internal class SimpleTimer : IDisposable
    {
        private readonly Stopwatch _sw;
        private readonly string _description;

        public SimpleTimer(string category, string description)
        {
#if TIMERS
            _sw = Stopwatch.StartNew();
            _description = "[" + category + "]" + description;
#endif
        }

        public void Dispose()
        {
#if TIMERS
            _sw.Stop();
            Logger.Debug(_description + ": " + _sw.ElapsedMilliseconds + " ms");
#endif
        }
    }
}
