﻿using System;
using System.Collections.Specialized;
using Curse.Cerium;
using Curse.CloudServices.Models;
using Curse.Friends.WebService.Requests;
using Curse.Friends.WebService.Responses;
using Newtonsoft.Json;

namespace Curse.Friends.RestClient
{
    public class FriendsRestClient : CeriumRestClient<FriendsRestClient>
    {
        private static string _authTokenJson;

        public static readonly FriendsRestClient Instance = new FriendsRestClient();

        static FriendsRestClient()
        {
            Configuration.TimeoutSeconds = 5;
            Configuration.UserAgent = "Curse/1.0";
        }

        public static void SetAuthToken(int userID, string token)
        {
            var authToken = new AuthenticationToken { UserID = userID, Token = token };            
            _authTokenJson = JsonConvert.SerializeObject(authToken);
        }

        public static void Initialize(string serviceBaseUrl)
        {
            if (!serviceBaseUrl.EndsWith("/"))
            {
                serviceBaseUrl = serviceBaseUrl + "/";
            }

            ServiceBaseUrl = serviceBaseUrl;
        }

        private FriendsRestClient()
        {
            
        }

        protected override NameValueCollection GetCustomHeaders()
        {
            if (string.IsNullOrEmpty(_authTokenJson))
            {
                throw new InvalidOperationException("You must first supply a valid auth token by calling the SetAuthToken method.");
            }

            return new NameValueCollection() { { AuthenticationToken.HeaderName, _authTokenJson } };
        }

        #region Service Methods

        #region Friends

        public RegisterSelfResponse RegisterSelf(RegisterSelfRequest request)
        {
            return Post<RegisterSelfRequest, RegisterSelfResponse>(request);
        }

        public GetMyFriendsResponse GetMyFriends()
        {
            return Get<GetMyFriendsResponse>("GetMyFriends");
        }

        public RequestFriendshipResponse RequestFriendship(FriendshipRequest request)
        {
            return Post<FriendshipRequest, RequestFriendshipResponse>(request, "RequestFriendship");
        }

        public GetMyFriendSuggestionsResponse GetMyFriendSuggestions()
        {
            return Get<GetMyFriendSuggestionsResponse>("GetMyFriendSuggestions");
        }

        public GetFriendsOfFriendResponse GetFriendsOfFriend(int friendID)
        {
            return Post<int, GetFriendsOfFriendResponse>(friendID, "GetFriendsOfFriend");
        }

        #endregion

        #region Groups

        public GetMyGroupsResponse GetMyGroups()
        {
            return Get<GetMyGroupsResponse>("GetMyGroups");
        }

        public GetGroupDetailsResponse GetGroupDetails(GroupDetailsRequest request)
        {
            return Post<GroupDetailsRequest, GetGroupDetailsResponse>(request, "GetGroupDetails");
        }

        public CreateGroupResponse CreateGroup(CreateGroupRequest request)
        {
            return Post<CreateGroupRequest, CreateGroupResponse>(request);
        }

        public BasicServiceResponse AddUserToGroup(AddUserToGroupRequest request)
        {
            return Post<AddUserToGroupRequest, BasicServiceResponse>(request, "AddUsersToGroup");
        }

        public BasicServiceResponse ChangeGroupNotificationPreferences(ChangeGroupNotificationPreferencesRequest request)
        {
            return Post<ChangeGroupNotificationPreferencesRequest, BasicServiceResponse>(request);
        }

        public ConfirmFriendshipResponse ConfirmFriendship(ConfirmFriendshipRequest request)
        {
            return Post<ConfirmFriendshipRequest, ConfirmFriendshipResponse>(request);
        }

        public DeclineFriendshipResponse DeclineFriendship(DeclineFriendshipRequest request)
        {
            return Post<DeclineFriendshipRequest, DeclineFriendshipResponse>(request);
        }

        public ToggleFavoriteResponse ToggleFavorite(ToggleFavoriteRequest request)
        {
            return Post<ToggleFavoriteRequest, ToggleFavoriteResponse>(request);
        }

        public ChangeProfileResponse ChangeProfile(ChangeProfileRequest request)
        {
            return Post<ChangeProfileRequest, ChangeProfileResponse>(request);
        }

        public ChangeStatusResponse ChangeStatus(ChangeStatusRequest request)
        {
            return Post<ChangeStatusRequest, ChangeStatusResponse>(request);
        }


        public RenameFriendResponse RenameFriend(RenameFriendRequest request)
        {
            return Post<RenameFriendRequest, RenameFriendResponse>(request);
        }

        public UserProfileResponse GetUserProfile(int userID)
        {
            return Post<int, UserProfileResponse>(userID, "GetUserProfile");
        }

        public BasicServiceResponse DeclineFriendSuggestion(DeclineFriendSuggestionRequest request)
        {
            return Post<DeclineFriendSuggestionRequest, BasicServiceResponse>(request);
        }

        public FriendSearchResponse FindFriends(FriendSearchRequest request)
        {
            return Post<FriendSearchRequest, FriendSearchResponse>(request, "FindFriends");
        }

        public BasicServiceResponse RemoveFriendship(RemoveFriendshipRequest request)
        {
            return Post<RemoveFriendshipRequest, BasicServiceResponse>(request);
        }

        public BasicServiceResponse ToggleFavoriteGroup(FavoriteGroupRequest request)
        {
            return Post<FavoriteGroupRequest, BasicServiceResponse>(request, "ToggleFavoriteGroup");
        }

        public BasicServiceResponse LeaveGroup(LeaveGroupRequest request)
        {
            return Post<LeaveGroupRequest, BasicServiceResponse>(request);
        }

        public BasicServiceResponse ChangeGroupInfo(ChangeGroupRequest request)
        {
            return Post<ChangeGroupRequest, BasicServiceResponse>(request, "ChangeGroupInfo");
        }

        public GetMyPushNotificationPreferencesResponse GetMyPushNotificationPreferences()
        {
            return Get<GetMyPushNotificationPreferencesResponse>("GetMyPushNotificationPreferences");
        }

        public BasicServiceResponse ChangePushNotificationPreferences(ChangePushNotificationPreferencesRequest request)
        {
            return Post<ChangePushNotificationPreferencesRequest, BasicServiceResponse>(request);
        }

        #endregion

        #region Misc

        public BasicServiceResponse UnregisterEndpoint(UnregisterEndpointRequest request)
        {
            return Post<UnregisterEndpointRequest, BasicServiceResponse>(request);
        }

        public GetHostListResponse GetHostList()
        {
            return Get<GetHostListResponse>("GetHostList");
        }

        public BasicServiceResponse UpdateDeviceTokens(UpdateDeviceTokensRequest request)
        {
            return Post<UpdateDeviceTokensRequest, BasicServiceResponse>(request);
        }
        

        #endregion

        #region Calls

        public VoiceSessionResponse CallFriend(CallFriendRequest request)
        {
            return Post<CallFriendRequest, VoiceSessionResponse>(request);
        }


        public VoiceSessionResponse CallGroup(CallGroupRequest request)
        {
            return Post<CallGroupRequest, VoiceSessionResponse>(request);
        }


        public BasicServiceResponse AddFriendToCall(AddFriendToCallRequest request)
        {
            return Post<AddFriendToCallRequest, BasicServiceResponse>(request);
        }

        public BasicServiceResponse UnlockCall(UnlockCallRequest request)
        {
            return Post<UnlockCallRequest, BasicServiceResponse>(request);
        }

        #endregion

        #endregion
    }
}
