﻿
# Friends Rest Client

The Curse Friends Rest Client is designed to provide simple, highly performant access to the friends web service.

## Cerium Configuration

The following explains how to configure Cerium. While not required, the following two configuration options may be necessary:

**SSL Ceritifcate Validation**

Depending on the environment you are accessing (dev, staging, production), you may or may not be using self-signed certs. If this is the case you must disable certification validation. 

```
CeriumConfiguration.DisableCertificateValidation();
```

**Service Stack**

Cerium depends on the Service Stack JSON serializer. The free version supports up to 20 different classes per app-domain. If you app uses more than this, you will need to supply a license key. 

```
CeriumConfiguration.ServiceStackLicenseKey = @"YOUR-LICENSE-KEY";
```
&nbsp;
## Friends Rest Client Configuration

Before the Friends Rest Client can be used, it must first be initialized. Base configuration for the Friends Rest Client is minimal. 

```
FriendsRestClient.Initialize(serviceUrl, userID, userAuthToken);
```


- **Service Url** (String): The web service is available in staging and production. You must supply the url as a string (https is required).

 &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Staging: https://friends-service.cursevoice.stg/FriendsService.svc/json

 &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Production: https://friends-service.ccloud.io/FriendsService.svc/json

- **User ID** (Int32): The ID of the user accessing the service.

- **User Auth Token** (String): The encrypted token returned from the login service used to authenticate the user.

&nbsp;
## Advanced Configuration

In addition to required configuration exposed through the Initialize method, advanced configuration options are exposed through the Configuration property of the Friends Rest Client singleton. Below are the default configuration options, that can be changed at runtime.

```
FriendsRestClient.Instance.Configuration.DisableProxyDetection = true;
FriendsRestClient.Instance.Configuration.UserAgent = "Curse/1.0";
FriendsRestClient.Instance.Configuration.ContentType = "application/json";
FriendsRestClient.Instance.Configuration.TimeoutSeconds = 10;
```

- **DisableProxyDetection** (Boolean): When True, the internal .NET web client will not attempt to detect http proxy information. This is used to speed up the client.

- **UserAgent** (String): Supplied in the request header with each request so that the server can identify the client type.

- **ContentType** (String): Supplied in the request header with each request so that the server knows the content type to expect in the request and to supply in the response. Setting this to anything other than application/json is currently unsupported.

- **TimeoutSeconds** (Int32): How long the client should wait to receive a response from the service. This should be tuned based on the connection quality of the client.

&nbsp;
## Methods
The Friends Rest Client is a singleton implementation that provides one line access to every web service method available. All method responses include a Status property, which is either a BasicServiceResponseStatus for more generic requests or a specifically typed status.

&nbsp;
#### RegisterSelf

Before connecting to the Friends Notification Server clients must first register. This is achieved with the RegisterSelf method.

```
var resp = FriendsRestClient.Instance.RegisterSelf(new RegisterSelfRequest 
	{ 
		MachineKey = YourMachineKey,
		Platform = DevicePlatform.iOS,
		DeviceID = YourDeviceToken
	});
```

- **Machine Key** (String): The auto generated GUID used to uniquely identify this device within
   a user's account.
   
- **Platform** (DevicePlatforn enum): The kind of device you are registering.
   
- **DeviceID** (string): Optional. The device id / token for mobile devices. It is used for
   push notifications.

&nbsp;
#### GetMyFriends

Before connecting the the notification server the client must retrieve the user's friends list. The response includes a status, and if successful a full array of the user's friends list.

```
var resp = FriendsRestClient.Instance.GetMyFriends();
```

&nbsp;
#### GetMyGroups

Before connecting the the notification server the client must also retrieve the user's group memberships. The response includes a status, and if successful a full array of the user's group memberships.

```
var resp = FriendsRestClient.Instance.GetMyGroups();
```

&nbsp;
#### GetMyPushNotificationPreferences

A user's push notification preferences can be retrieved using the following method.

```
var resp = FriendsRestClient.Instance.GetMyPushNotificationPreferences();
```

&nbsp;
#### ChangePushNotificationPreferences

A user's push notification preferences can be updated using the following method.

```
var resp = FriendsRestClient.Instance.ChangePushNotificationPreferences();
```

&nbsp;
## Sample


Here's a simple example that demonstrates a fully working implementation of the client. Please note that for this example no exception handling is in place for readability. In an actual client **all** web service calls should be wrapped in a try catch pattern, with proper logging and error handling.

```
// TODO: Login to the central login server to get an auth token

// Initialize Cerium with the service stack license
CeriumConfiguration.ServiceStackLicenseKey = @"YOUR-LICENSE-KEY";

// Initialize the rest client with the url, user id, and auth token
FriendsRestClient.Initialize("https://friends-service.cursevoice.stg/FriendsService.svc/json", 1000, "SOME-TOKEN");

// Try to register to get a notification server session
var registerResp = FriendsRestClient.Instance.RegisterSelf(new RegisterSelfRequest 
	{ 
		MachineKey = "SOME-MACHINE-KEY",
		Platform = DevicePlatform.iOS,
		DeviceID = "SOME-DEVICE-TOKEN"
	});

// Check our response status	
if(registerResp.Status != RegisterSelfStatus.Successful)
{
	Logger.Warn("Failed to register self!", registerResp);
	return;
}

var friendsResp = FriendsRestClient.Instance.GetMyFriends();

if(friendsResp.Status != GetMyFriendsStatus.Successful)
{
	Logger.Warn("Failed to get friends!", friendsResp);
	return;
}

var groupResp = FriendsRestClient.Instance.GetMyGroups();

if(friendsResp.Status != BasicServiceResponseStatus.Successful)
{
	Logger.Warn("Failed to get groups!", groupResp );
	return;
}

foreach(var friend in friendsResp.Friends)
{
	// Do something
}

foreach(var group in groupResp.Groups)
{
	// Do something
}

// Update current user's display info using:
// registerResp.User

// Connect to the notification server using:
// registerResp.NotificationHostList
// registerResp.NotificationHostPorts
// registerResp.SessionID

```