﻿using Curse.Cerium;
using Curse.ServiceAuthentication.Models;

namespace Curse.LoginService.RestClient
{
    public class LoginServiceRestClient : CeriumRestClient<LoginServiceRestClient>
    {
        public static readonly LoginServiceRestClient Instance = new LoginServiceRestClient();

        static LoginServiceRestClient()
        {
            Configuration.TimeoutSeconds = 5;
            Configuration.UserAgent = "Curse/1.0";
        }
        
        public static void Initialize(string serviceBaseUrl)
        {
            ServiceBaseUrl = serviceBaseUrl;
            
        }

        protected LoginServiceRestClient()
        {
            
        }

        public LoginResponse Login(string username, string password)
        {
            var encryptedPassword = AuthenticationEncryption.EncryptPassword(password);
            return Post<LoginRequest, LoginResponse>(new LoginRequest { Username = username, EncryptedPassword = encryptedPassword });
        }

        public RegisterUserResult Register(string email, string username, string password, bool newsletterOptIn = false)
        {
            return Post<RegisterRequest, RegisterUserResult>(new RegisterRequest { Username = username, Password = password, Email = email, NewsletterOptIn = newsletterOptIn });
        }

        public bool CheckUsernameAvailability(string username)
        {
            return Post<CheckUsernameAvailabilityRequest, bool>(new CheckUsernameAvailabilityRequest { Username = username });
        }        
    }
}
