﻿
# Login Service Rest Client

The Curse Login Service Rest Client is designed to provide blazing fast logins.

## Cerium Configuration

The following explains how to configure Cerium. While not required, the following two configuration options may be necessary:

**SSL Ceritifcate Validation**

Depending on the environment you are accessing (dev, staging, production), you may or may not be using self-signed certs. If this is the case you must disable certification validation. 

```
CeriumConfiguration.DisableCertificateValidation();
```

**Service Stack**

Cerium depends on the Service Stack JSON serializer. The free version supports up to 20 different classes per app-domain. If you app uses more than this, you will need to supply a license key. 

```
CeriumConfiguration.ServiceStackLicenseKey = @"YOUR-LICENSE-KEY";
```
&nbsp;
## Login Service Rest Client Configuration

Before the Login Service Rest Client can be used, it must first be initialized. Base configuration for the client is minimal. 

```
LoginServiceRestClient.Initialize(serviceUrl);
```


- **Service Url** (String): The web service is available in staging and production. You must supply the url as a string (https is required).

 &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Staging: https://clientservice-v6.curse.stg/ClientLoginService.svc/json/

 &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Production: https://clientservice-v6-beta.curse.com/ClientLoginService.svc/json/

&nbsp;
## Advanced Configuration

In addition to required configuration exposed through the Initialize method, advanced configuration options are exposed through the Configuration property of the Login Service Rest Client singleton. Below are the default configuration options, that can be changed at runtime.

```
LoginServiceRestClient.Instance.Configuration.DisableProxyDetection = true;
LoginServiceRestClient.Instance.Configuration.UserAgent = "Curse/1.0";
LoginServiceRestClient.Instance.Configuration.ContentType = "application/json";
LoginServiceRestClient.Instance.Configuration.TimeoutSeconds = 10;
```

- **DisableProxyDetection** (Boolean): When True, the internal .NET web client will not attempt to detect http proxy information. This is used to speed up the client.

- **UserAgent** (String): Supplied in the request header with each request so that the server can identify the client type.

- **ContentType** (String): Supplied in the request header with each request so that the server knows the content type to expect in the request and to supply in the response. Setting this to anything other than application/json is currently unsupported.

- **TimeoutSeconds** (Int32): How long the client should wait to receive a response from the service. This should be tuned based on the connection quality of the client.

&nbsp;
## Methods
The LoginService Rest Client is a singleton implementation that provides one line access to every web service method available.

&nbsp;
#### Login

The only method currently implemented is login.

```
var resp = LoginServiceRestClient.Instance.Login(username, password);
```

**Parameters**

- **username** (String): The username or email address of the user.
   
- **password** (String): The plain text password for the user. This is automatically encrypted before transmission.  

**Return Value**
The Login method returns a LoginResponse, which consists of two properties, Status and Session. 

Session includes all of the information needed to authenticate with other web services, most importantly the Token.

Status is an AuthenticationStatus enum which has the following valus:

- Unsuccessful = 0,
- Success = 1,
- InvalidSession = 2,
- UnauthorizedLogin = 3,
- InvalidPassword = 4,
- UnknownUsername = 5,
- UnknownEmail = 6,
- UnknownError = 100,
- IncorrectTime = 101,
- CorruptLibrary = 102,
- OutdatedClient = 103,
- SubscriptionMismatch = 104,
- SubscriptionExpired = 105,
- InsufficientAccessLevel = 106,
- InvalidApiKey = 107,
- MissingGrant = 108

&nbsp;

## Sample

Here's a simple example that demonstrates a fully working implementation of the client. Please note that for this example no exception handling is in place for readability. In an actual client **all** web service calls should be wrapped in a try catch pattern, with proper logging and error handling.

```
// TODO: Login to the central login server to get an auth token

// Initialize Cerium with the service stack license
CeriumConfiguration.ServiceStackLicenseKey = @"YOUR-LICENSE-KEY";

// Initialize the rest client with the url, user id, and auth token
LoginServiceRestClient.Initialize("https://clientservice-v6.curse.stg/ClientLoginService.svc/json/");

// Try to register to get a notification server session
var resp = LoginServiceRestClient.Instance.Login("SOME-USER", "SOME-PASSWORD");

// Check our response status	
if(resp.Status != AuthenticationStatus.Successful)
{
	Logger.Warn("Failed to login!", resp);
	return;
}

// Use the token to authenticate to all other web services
var authenticationToken = resp.Session.Token;


```