﻿using System;
using System.Collections.Specialized;
using Curse.Cerium;
using Curse.CloudServices.Models;
using Curse.Voice.Service.Requests;
using Curse.Voice.Service.Responses;
using Newtonsoft.Json;

namespace Curse.Voice.RestClient
{
    public class VoiceRestClient : CeriumRestClient<VoiceRestClient>
    {
        private static string _authTokenJson;

        public static readonly VoiceRestClient Instance = new VoiceRestClient();

        static VoiceRestClient()
        {
            Configuration.TimeoutSeconds = 5;
            Configuration.UserAgent = "Curse/1.0";
        }

        public static void SetAuthToken(int userID, string token)
        {
            var authToken = new AuthenticationToken { UserID = userID, Token = token };            
            _authTokenJson = JsonConvert.SerializeObject(authToken);
        }

        public static void Initialize(string serviceBaseUrl)
        {
            if (!serviceBaseUrl.EndsWith("/"))
            {
                serviceBaseUrl = serviceBaseUrl + "/";
            }

            ServiceBaseUrl = serviceBaseUrl;
        }

        private VoiceRestClient()
        {
            
        }

        protected override NameValueCollection GetCustomHeaders()
        {
            if (string.IsNullOrEmpty(_authTokenJson))
            {
                throw new InvalidOperationException("You must first supply a valid auth token by calling the SetAuthToken method.");
            }

            return new NameValueCollection() { { AuthenticationToken.HeaderName, _authTokenJson } };
        }
        

        #region Friends

        public GetVoiceSessionResponse GetVoiceSession(GetVoiceSessionRequest request)
        {
            return Post<GetVoiceSessionRequest, GetVoiceSessionResponse>(request);
        }

        #endregion
    }
}
