﻿using Microsoft.WindowsAzure.Storage;
using Microsoft.WindowsAzure.Storage.Auth;
using Microsoft.WindowsAzure.Storage.Table;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace TestApp
{
    public class AzureClientHelper
    {
        private readonly string _accountName;
        private readonly string _accountKey;

        private AzureClientHelper()
        {
            _accountName = Azure.Default.AccountName;
            _accountKey = Azure.Default.AccountKeyPrimary;
        }

        private static AzureClientHelper _instance = new AzureClientHelper();
        public static AzureClientHelper Instance
        {
            get
            {
                return _instance;
            }
        }

        public CloudTableClient GetClient()
        {
            StorageCredentials credentials = new StorageCredentials(_accountName, _accountKey);
            CloudStorageAccount account = new CloudStorageAccount(credentials, true);
            return account.CreateCloudTableClient();
        }
    }
}
